package server

import (
	"context"
	"errors"
	"testing"

	"code.justin.tv/vod/vodapi/internal/testdata"
	rpc "code.justin.tv/vod/vodapi/rpc/vodapi"
	"code.justin.tv/vod/vodapi/rpc/vodapi/utils"
	"github.com/golang/protobuf/ptypes/wrappers"
	. "github.com/smartystreets/goconvey/convey"
	. "github.com/stretchr/testify/mock"
	"github.com/twitchtv/twirp"
)

func TestManagerUpdateVod(t *testing.T) {
	Convey("when calling ManagerUpdateVod", t, func() {
		server, mocks := initTestableServer()
		ctx := context.Background()

		newTitleWrapper := wrappers.StringValue{Value: "new_title"}
		request := &rpc.ManagerUpdateVodRequest{
			VodId: utils.Int64ToStr(testdata.VodID1),
			Title: &newTitleWrapper,
		}

		Convey("when ManagerUpdateVod succeeds", func() {
			rpcUpload := testdata.RPCUploadVod()
			uploadVod := testdata.UploadVod()
			mocks.backend.On("ManagerUpdateVod", ctx, Anything).Return(uploadVod, nil)
			resp, err := server.ManagerUpdateVod(ctx, request)
			So(err, ShouldBeNil)
			So(resp, ShouldResemble, &rpc.ManagerUpdateVodResponse{Vod: rpcUpload})
		})
		Convey("when ManagerUpdateVod fails", func() {
			mocks.MockTwirpErrorConvert()
			mocks.backend.On("ManagerUpdateVod", ctx, Anything).Return(nil, errors.New("foo"))
			resp, err := server.ManagerUpdateVod(ctx, request)
			So(resp, ShouldBeNil)
			So(err, ShouldBeError)
			twirpError := err.(twirp.Error)
			So(twirpError.Code(), ShouldEqual, twirp.Internal)
		})
		mocks.AssertExpectations(t)
	})
}
