package server

import (
	"golang.org/x/net/context"

	"code.justin.tv/vod/vodapi/internal/models"
	"code.justin.tv/vod/vodapi/internal/server/converters"
	rpc "code.justin.tv/vod/vodapi/rpc/vodapi"
	"code.justin.tv/vod/vodapi/rpc/vodapi/utils"
)

// PublicGetVodByID should make a backend call
func (s *Server) PublicGetVodByID(ctx context.Context, r *rpc.PublicGetVodByIDRequest) (*rpc.PublicGetVodByIDResponse, error) {
	internalResponse, err := s.backend.PublicGetVodByID(ctx, &models.PublicGetVodByIDRequest{
		VodID: utils.StrToInt64(r.VodId),
	})
	if err != nil {
		return nil, converters.ConvertToTwirpError(err, s.errorlogger)
	}
	return &rpc.PublicGetVodByIDResponse{Vod: converters.ConvertInternalVod(internalResponse)}, nil
}
