package server

import (
	"context"
	"errors"
	"testing"

	rpc "code.justin.tv/vod/vodapi/rpc/vodapi"
	"code.justin.tv/vod/vodapi/rpc/vodapi/utils"

	"code.justin.tv/vod/vodapi/internal/testdata"
	. "github.com/smartystreets/goconvey/convey"
	. "github.com/stretchr/testify/mock"
	"github.com/twitchtv/twirp"
)

func TestPublicGetVodByID(t *testing.T) {
	Convey("when calling PublicGetVodByID", t, func() {
		server, mocks := initTestableServer()
		ctx := context.Background()

		request := &rpc.PublicGetVodByIDRequest{
			VodId: utils.Int64ToStr(testdata.VodID1),
		}

		Convey("when PublicGetVodByID succeeds", func() {
			rpcUpload := testdata.RPCUploadVod()
			uploadVod := testdata.UploadVod()
			mocks.backend.On("PublicGetVodByID", ctx, Anything).Return(uploadVod, nil)
			resp, err := server.PublicGetVodByID(ctx, request)
			So(err, ShouldBeNil)
			So(resp, ShouldResemble, &rpc.PublicGetVodByIDResponse{Vod: rpcUpload})
		})
		Convey("when PublicGetVodByID fails", func() {
			mocks.MockTwirpErrorConvert()
			mocks.backend.On("PublicGetVodByID", ctx, Anything).Return(nil, errors.New("foo"))
			resp, err := server.PublicGetVodByID(ctx, request)
			So(resp, ShouldBeNil)
			So(err, ShouldBeError)
			twirpError := err.(twirp.Error)
			So(twirpError.Code(), ShouldEqual, twirp.Internal)
		})
		mocks.AssertExpectations(t)
	})
}
