package server

import (
	"context"
	"errors"
	"testing"

	"code.justin.tv/vod/vodapi/internal/models"
	"code.justin.tv/vod/vodapi/internal/testdata"
	rpc "code.justin.tv/vod/vodapi/rpc/vodapi"
	"code.justin.tv/vod/vodapi/rpc/vodapi/utils"
	. "github.com/smartystreets/goconvey/convey"
	. "github.com/stretchr/testify/mock"
	"github.com/twitchtv/twirp"
)

func TestPublicGetVodsByIDs(t *testing.T) {
	Convey("when calling PublicGetVodsByIDs", t, func() {
		server, mocks := initTestableServer()
		ctx := context.Background()

		request := &rpc.PublicGetVodsByIDsRequest{
			VodIds: []string{utils.Int64ToStr(testdata.VodID1)},
		}

		Convey("when PublicGetVodsByIDs succeeds", func() {
			rpcUpload := testdata.RPCUploadVod()
			uploadVod := testdata.UploadVod()
			vods := []*models.Vod{uploadVod}
			vodsResponse := &models.VodsResponse{
				Vods: vods,
			}
			mocks.backend.On("PublicGetVodsByIDs", ctx, Anything).Return(vodsResponse, nil)
			resp, err := server.PublicGetVodsByIDs(ctx, request)
			So(err, ShouldBeNil)
			So(resp, ShouldNotBeNil)
			So(len(resp.Vods), ShouldEqual, 1)
			So(resp.Vods[0], ShouldResemble, rpcUpload)
		})
		Convey("when PublicGetVodsByIDs fails", func() {
			mocks.MockTwirpErrorConvert()
			mocks.backend.On("PublicGetVodsByIDs", ctx, Anything).Return(nil, errors.New("foo"))
			resp, err := server.PublicGetVodsByIDs(ctx, request)
			So(resp, ShouldBeNil)
			So(err, ShouldBeError)
			twirpError := err.(twirp.Error)
			So(twirpError.Code(), ShouldEqual, twirp.Internal)
		})
		mocks.AssertExpectations(t)
	})
}
