package server

import (
	"golang.org/x/net/context"

	"code.justin.tv/vod/vodapi/internal/models"
	"code.justin.tv/vod/vodapi/internal/server/converters"
	rpc "code.justin.tv/vod/vodapi/rpc/vodapi"
	"code.justin.tv/vod/vodapi/rpc/vodapi/utils"
)

// PublicGetVodsByUser should make a backend call
func (s *Server) PublicGetVodsByUser(ctx context.Context, r *rpc.PublicGetVodsByUserRequest) (*rpc.PublicGetVodsByUserResponse, error) {
	request := &models.PublicGetVodsByUserRequest{
		ChannelID:      utils.StrToInt64(r.ChannelId),
		BroadcastTypes: rpc.ConvertVodTypes(r.BroadcastTypes),
		Language:       r.Language,
		Status:         rpc.ConvertVodStatus(r.Status),
		Sort:           rpc.ConvertVodSort(r.Sort),
		Limit:          r.Limit,
		Offset:         r.Offset,
	}
	recordedAfter := utils.FromProtobufTimestampToTime(r.RecordedAfter)
	if recordedAfter != nil && !recordedAfter.IsZero() {
		request.RecordedAfter = recordedAfter
	}
	recordedBefore := utils.FromProtobufTimestampToTime(r.RecordedBefore)
	if recordedBefore != nil && !recordedBefore.IsZero() {
		request.RecordedBefore = recordedBefore
	}
	internalResponse, err := s.backend.PublicGetVodsByUser(ctx, request)
	if err != nil {
		return nil, converters.ConvertToTwirpError(err, s.errorlogger)
	}
	return &rpc.PublicGetVodsByUserResponse{Vods: converters.ConvertInternalVods(internalResponse)}, nil
}
