package server

import (
	"golang.org/x/net/context"

	"code.justin.tv/vod/vodapi/internal/models"
	"code.justin.tv/vod/vodapi/internal/server/converters"
	rpc "code.justin.tv/vod/vodapi/rpc/vodapi"
	"code.justin.tv/vod/vodapi/rpc/vodapi/utils"
)

// PublicGetVodsByUsers should make a backend call
func (s *Server) PublicGetVodsByUsers(ctx context.Context, r *rpc.PublicGetVodsByUsersRequest) (*rpc.PublicGetVodsByUsersResponse, error) {
	request := &models.PublicGetVodsByUsersRequest{
		ChannelIDs:     utils.StrArrayToInt64Array(r.ChannelIds),
		BroadcastTypes: rpc.ConvertVodTypes(r.BroadcastTypes),
		Language:       r.Language,
		Sort:           r.Sort,
		Limit:          r.Limit,
		Offset:         r.Offset,
	}
	internalResponse, err := s.backend.PublicGetVodsByUsers(ctx, request)
	if err != nil {
		return nil, converters.ConvertToTwirpError(err, s.errorlogger)
	}
	return &rpc.PublicGetVodsByUsersResponse{Vods: converters.ConvertInternalVods(internalResponse)}, nil
}
