package server

import (
	"golang.org/x/net/context"

	"code.justin.tv/vod/vodapi/internal/models"
	"code.justin.tv/vod/vodapi/internal/server/converters"
	rpc "code.justin.tv/vod/vodapi/rpc/vodapi"
	"code.justin.tv/vod/vodapi/rpc/vodapi/utils"
)

// ResolveTrackAppeal should make a backend call
func (s *Server) ResolveTrackAppeal(ctx context.Context, r *rpc.ResolveTrackAppealRequest) (*rpc.ResolveTrackAppealResponse, error) {
	err := s.backend.ResolveTrackAppeal(ctx, &models.ResolveTrackAppealRequest{
		TrackAppealID: utils.StrToInt64(r.TrackAppealId),
		Action:        r.Action,
	})
	if err != nil {
		return nil, converters.ConvertToTwirpError(err, s.errorlogger)
	}
	return &rpc.ResolveTrackAppealResponse{}, nil
}
