package server

import (
	"context"
	"errors"
	"testing"

	rpc "code.justin.tv/vod/vodapi/rpc/vodapi"
	. "github.com/smartystreets/goconvey/convey"
	. "github.com/stretchr/testify/mock"
	"github.com/twitchtv/twirp"
)

func TestResolveTrackAppeal(t *testing.T) {
	Convey("when calling ResolveTrackAppeal", t, func() {
		server, mocks := initTestableServer()
		ctx := context.Background()

		request := &rpc.ResolveTrackAppealRequest{
			TrackAppealId: "1234",
			Action:        "resolve",
		}

		Convey("when ResolveTrackAppeal succeeds", func() {
			mocks.backend.On("ResolveTrackAppeal", ctx, Anything).Return(nil)
			resp, err := server.ResolveTrackAppeal(ctx, request)
			So(err, ShouldBeNil)
			So(resp, ShouldNotBeNil)
		})
		Convey("when ResolveTrackAppeal fails", func() {
			mocks.MockTwirpErrorConvert()
			mocks.backend.On("ResolveTrackAppeal", ctx, Anything).Return(errors.New("foo"))
			resp, err := server.ResolveTrackAppeal(ctx, request)
			So(resp, ShouldBeNil)
			So(err, ShouldBeError)
			twirpError := err.(twirp.Error)
			So(twirpError.Code(), ShouldEqual, twirp.Internal)
		})
		mocks.AssertExpectations(t)
	})
}
