package server

import (
	"golang.org/x/net/context"

	"code.justin.tv/vod/vodapi/internal/models"
	"code.justin.tv/vod/vodapi/internal/server/converters"
	rpc "code.justin.tv/vod/vodapi/rpc/vodapi"
	"code.justin.tv/vod/vodapi/rpc/vodapi/utils"
)

// ResolveVodAppeal should make a backend call
func (s *Server) ResolveVodAppeal(ctx context.Context, r *rpc.ResolveVodAppealRequest) (*rpc.ResolveVodAppealResponse, error) {
	err := s.backend.ResolveVodAppeal(ctx, &models.ResolveVodAppealRequest{
		VodAppealID: utils.StrToInt64(r.VodAppealId),
	})
	if err != nil {
		return nil, converters.ConvertToTwirpError(err, s.errorlogger)
	}
	return &rpc.ResolveVodAppealResponse{}, nil
}
