package server

import (
	"context"
	"errors"
	"testing"

	rpc "code.justin.tv/vod/vodapi/rpc/vodapi"
	. "github.com/smartystreets/goconvey/convey"
	. "github.com/stretchr/testify/mock"
	"github.com/twitchtv/twirp"
)

func TestResolveVodAppeal(t *testing.T) {
	Convey("when calling ResolveVodAppeal", t, func() {
		server, mocks := initTestableServer()
		ctx := context.Background()

		request := &rpc.ResolveVodAppealRequest{
			VodAppealId: "1234",
		}

		Convey("when ResolveVodAppeal succeeds", func() {
			mocks.backend.On("ResolveVodAppeal", ctx, Anything).Return(nil)
			resp, err := server.ResolveVodAppeal(ctx, request)
			So(err, ShouldBeNil)
			So(resp, ShouldNotBeNil)
		})
		Convey("when ResolveVodAppeal fails", func() {
			mocks.MockTwirpErrorConvert()
			mocks.backend.On("ResolveVodAppeal", ctx, Anything).Return(errors.New("foo"))
			resp, err := server.ResolveVodAppeal(ctx, request)
			So(resp, ShouldBeNil)
			So(err, ShouldBeError)
			twirpError := err.(twirp.Error)
			So(twirpError.Code(), ShouldEqual, twirp.Internal)
		})
		mocks.AssertExpectations(t)
	})
}
