package server

import (
	"golang.org/x/net/context"

	"code.justin.tv/vod/vodapi/internal/models"
	"code.justin.tv/vod/vodapi/internal/server/converters"
	rpc "code.justin.tv/vod/vodapi/rpc/vodapi"
	"code.justin.tv/vod/vodapi/rpc/vodapi/utils"
)

// SetViewcounts should make a backend call
func (s *Server) SetViewcounts(ctx context.Context, r *rpc.SetViewcountsRequest) (*rpc.SetViewcountsResponse, error) {
	viewcounts := make([]models.ViewcountsUpdate, len(r.Viewcounts))
	for i, viewcount := range r.Viewcounts {
		viewcounts[i] = models.ViewcountsUpdate{
			VodID: utils.StrToInt64(viewcount.VodId),
			Count: viewcount.Count,
		}
	}
	err := s.backend.SetViewcounts(ctx, &models.SetViewcountsRequest{
		Viewcounts: viewcounts,
	})
	if err != nil {
		return nil, converters.ConvertToTwirpError(err, s.errorlogger)
	}
	return &rpc.SetViewcountsResponse{}, nil
}
