package server

import (
	"context"
	"errors"
	"testing"

	"code.justin.tv/vod/vodapi/internal/testdata"
	rpc "code.justin.tv/vod/vodapi/rpc/vodapi"
	"code.justin.tv/vod/vodapi/rpc/vodapi/utils"
	. "github.com/smartystreets/goconvey/convey"
	. "github.com/stretchr/testify/mock"
	"github.com/twitchtv/twirp"
)

func TestSetViewcounts(t *testing.T) {
	Convey("when calling SetViewcounts", t, func() {
		server, mocks := initTestableServer()
		ctx := context.Background()

		request := &rpc.SetViewcountsRequest{
			Viewcounts: []*rpc.ViewcountsUpdate{
				&rpc.ViewcountsUpdate{
					VodId: utils.Int64ToStr(testdata.VodID1),
					Count: 5,
				},
			},
		}

		Convey("when SetViewcounts succeeds", func() {
			mocks.backend.On("SetViewcounts", ctx, Anything).Return(nil)
			resp, err := server.SetViewcounts(ctx, request)
			So(err, ShouldBeNil)
			So(resp, ShouldNotBeNil)
		})
		Convey("when SetViewcounts fails", func() {
			mocks.MockTwirpErrorConvert()
			mocks.backend.On("SetViewcounts", ctx, Anything).Return(errors.New("something bad happened"))
			resp, err := server.SetViewcounts(ctx, request)
			So(resp, ShouldBeNil)
			So(err, ShouldBeError)
			twirpError := err.(twirp.Error)
			So(twirpError.Code(), ShouldEqual, twirp.Internal)
		})
		mocks.AssertExpectations(t)
	})
}
