package server

import (
	"golang.org/x/net/context"

	"code.justin.tv/vod/vodapi/internal/models"
	"code.justin.tv/vod/vodapi/internal/server/converters"
	rpc "code.justin.tv/vod/vodapi/rpc/vodapi"
	"code.justin.tv/vod/vodapi/rpc/vodapi/utils"
)

// SoftDeleteVods should make a backend call
func (s *Server) SoftDeleteVods(ctx context.Context, r *rpc.SoftDeleteVodsRequest) (*rpc.SoftDeleteVodsResponse, error) {
	internalResponse, err := s.backend.SoftDeleteVods(ctx, &models.SoftDeleteVodsRequest{
		VodIDs: utils.StrArrayToInt64Array(r.VodIds),
	})
	if err != nil {
		return nil, converters.ConvertToTwirpError(err, s.errorlogger)
	}
	return &rpc.SoftDeleteVodsResponse{Vods: converters.ConvertInternalVods(internalResponse)}, nil
}
