package server

import (
	"golang.org/x/net/context"

	"code.justin.tv/vod/vodapi/internal/models"
	"code.justin.tv/vod/vodapi/internal/server/converters"
	rpc "code.justin.tv/vod/vodapi/rpc/vodapi"
)

// SoftDeleteVodsInInterval should make a backend call
func (s *Server) SoftDeleteVodsInInterval(ctx context.Context, r *rpc.SoftDeleteVodsInIntervalRequest) (*rpc.SoftDeleteVodsInIntervalResponse, error) {
	err := s.backend.SoftDeleteVodsInInterval(ctx, &models.SoftDeleteVodsInIntervalRequest{
		StartTimeUnixSeconds: r.StartTimeUnixSeconds,
		EndTimeUnixSeconds:   r.EndTimeUnixSeconds,
	})
	if err != nil {
		return nil, converters.ConvertToTwirpError(err, s.errorlogger)
	}
	return &rpc.SoftDeleteVodsInIntervalResponse{}, nil
}
