package server

import (
	"context"
	"errors"
	"testing"

	rpc "code.justin.tv/vod/vodapi/rpc/vodapi"
	. "github.com/smartystreets/goconvey/convey"
	. "github.com/stretchr/testify/mock"
	"github.com/twitchtv/twirp"
)

func TestSoftDeleteVodsInInterval(t *testing.T) {
	Convey("when calling SoftDeleteVodsInInterval", t, func() {
		server, mocks := initTestableServer()
		ctx := context.Background()

		request := &rpc.SoftDeleteVodsInIntervalRequest{
			StartTimeUnixSeconds: 100,
			EndTimeUnixSeconds:   500,
		}

		Convey("when SoftDeleteVodsInInterval succeeds", func() {
			mocks.backend.On("SoftDeleteVodsInInterval", ctx, Anything).Return(nil)
			resp, err := server.SoftDeleteVodsInInterval(ctx, request)
			So(err, ShouldBeNil)
			So(resp, ShouldNotBeNil)
		})
		Convey("when SoftDeleteVodsInInterval fails", func() {
			mocks.MockTwirpErrorConvert()
			mocks.backend.On("SoftDeleteVodsInInterval", ctx, Anything).Return(errors.New("something bad happened"))
			resp, err := server.SoftDeleteVodsInInterval(ctx, request)
			So(resp, ShouldBeNil)
			So(err, ShouldBeError)
			twirpError := err.(twirp.Error)
			So(twirpError.Code(), ShouldEqual, twirp.Internal)
		})
		mocks.AssertExpectations(t)
	})
}
