package server

import (
	"code.justin.tv/vod/vodapi/internal/models"
	"code.justin.tv/vod/vodapi/internal/server/converters"
	rpc "code.justin.tv/vod/vodapi/rpc/vodapi"
	"code.justin.tv/vod/vodapi/rpc/vodapi/utils"
	"golang.org/x/net/context"
)

// UndeleteVods should make a backend call
func (s *Server) UndeleteVods(ctx context.Context, r *rpc.UndeleteVodsRequest) (*rpc.UndeleteVodsResponse, error) {
	internalResponse, err := s.backend.UndeleteVods(ctx, &models.UndeleteVodsRequest{
		VodIDs: utils.StrArrayToInt64Array(r.VodIds),
	})
	if err != nil {
		return nil, converters.ConvertToTwirpError(err, s.errorlogger)
	}
	return &rpc.UndeleteVodsResponse{Vods: converters.ConvertInternalVods(internalResponse)}, nil
}
