package server

import (
	"golang.org/x/net/context"

	"code.justin.tv/vod/vodapi/internal/server/converters"
	rpc "code.justin.tv/vod/vodapi/rpc/vodapi"
)

// UpdateAudibleMagicResponses should make a backend call
func (s *Server) UpdateAudibleMagicResponses(ctx context.Context, r *rpc.UpdateAudibleMagicResponsesRequest) (*rpc.AudibleMagicResponsesResponse, error) {
	internalResponse, err := s.backend.UpdateAudibleMagicResponses(ctx, converters.ConvertToInternalUpdateAudibleMagicResponses(r))
	if err != nil {
		return nil, converters.ConvertToTwirpError(err, s.errorlogger)
	}
	return converters.ConvertFromInternalAudibleMagicResponses(internalResponse), nil
}
