package server

import (
	"context"
	"errors"
	"testing"

	"code.justin.tv/vod/vodapi/internal/testdata"
	rpc "code.justin.tv/vod/vodapi/rpc/vodapi"
	"github.com/golang/protobuf/ptypes/wrappers"
	. "github.com/smartystreets/goconvey/convey"
	. "github.com/stretchr/testify/mock"
	"github.com/twitchtv/twirp"
)

func TestUpdateAudibleMagicResponses(t *testing.T) {
	Convey("when calling UpdateAudibleMagicResponses", t, func() {
		server, mocks := initTestableServer()
		ctx := context.Background()

		// TODO - [VODI-167]: this test should be more robust
		newTitleWrapper := wrappers.StringValue{Value: "new_title"}
		request := &rpc.UpdateAudibleMagicResponsesRequest{
			UpdateAudibleMagicResponses: []*rpc.UpdateAudibleMagicResponseRequest{
				&rpc.UpdateAudibleMagicResponseRequest{
					Title: &newTitleWrapper,
				},
			},
		}

		Convey("when UpdateAudibleMagicResponses succeeds", func() {
			mocks.backend.On("UpdateAudibleMagicResponses", ctx, Anything).Return(testdata.AudibleMagicResponses(), nil)
			resp, err := server.UpdateAudibleMagicResponses(ctx, request)
			So(err, ShouldBeNil)
			So(resp, ShouldNotBeNil)
		})
		Convey("when UpdateAudibleMagicResponses fails", func() {
			mocks.MockTwirpErrorConvert()
			mocks.backend.On("UpdateAudibleMagicResponses", ctx, Anything).Return(nil, errors.New("foo"))
			resp, err := server.UpdateAudibleMagicResponses(ctx, request)
			So(resp, ShouldBeNil)
			So(err, ShouldBeError)
			twirpError := err.(twirp.Error)
			So(twirpError.Code(), ShouldEqual, twirp.Internal)
		})
		mocks.AssertExpectations(t)
	})
}
