package server

import (
	"golang.org/x/net/context"

	"code.justin.tv/vod/vodapi/internal/models"
	"code.justin.tv/vod/vodapi/internal/server/converters"
	rpc "code.justin.tv/vod/vodapi/rpc/vodapi"
	"code.justin.tv/vod/vodapi/rpc/vodapi/utils"
)

// UpdateManifest should make a backend call
func (s *Server) UpdateManifest(ctx context.Context, r *rpc.UpdateManifestRequest) (*rpc.UpdateManifestResponse, error) {
	err := s.backend.UpdateManifest(ctx, &models.UpdateManifestRequest{
		VodID:       utils.StrToInt64(r.VodId),
		OldManifest: r.OldManifest,
		NewManifest: r.NewManifest,
	})
	if err != nil {
		return nil, converters.ConvertToTwirpError(err, s.errorlogger)
	}
	return &rpc.UpdateManifestResponse{}, nil
}
