package server

import (
	"context"
	"errors"
	"testing"

	"code.justin.tv/vod/vodapi/internal/testdata"
	rpc "code.justin.tv/vod/vodapi/rpc/vodapi"
	"code.justin.tv/vod/vodapi/rpc/vodapi/utils"
	. "github.com/smartystreets/goconvey/convey"
	. "github.com/stretchr/testify/mock"
	"github.com/twitchtv/twirp"
)

func TestUpdateManifest(t *testing.T) {
	Convey("when calling UpdateManifest", t, func() {
		server, mocks := initTestableServer()
		ctx := context.Background()

		request := &rpc.UpdateManifestRequest{
			VodId:       utils.Int64ToStr(testdata.VodID1),
			OldManifest: "old",
			NewManifest: "new",
		}

		Convey("when UpdateManifest succeeds", func() {
			mocks.backend.On("UpdateManifest", ctx, Anything).Return(nil)
			resp, err := server.UpdateManifest(ctx, request)
			So(err, ShouldBeNil)
			So(resp, ShouldNotBeNil)
		})
		Convey("when UpdateManifest fails", func() {
			mocks.MockTwirpErrorConvert()
			mocks.backend.On("UpdateManifest", ctx, Anything).Return(errors.New("something bad happened"))
			resp, err := server.UpdateManifest(ctx, request)
			So(resp, ShouldBeNil)
			So(err, ShouldBeError)
			twirpError := err.(twirp.Error)
			So(twirpError.Code(), ShouldEqual, twirp.Internal)
		})
		mocks.AssertExpectations(t)
	})
}
