package server

import (
	"golang.org/x/net/context"

	"code.justin.tv/vod/vodapi/internal/models"
	"code.justin.tv/vod/vodapi/internal/server/converters"
	rpc "code.justin.tv/vod/vodapi/rpc/vodapi"
	"code.justin.tv/vod/vodapi/rpc/vodapi/utils"
)

// YoutubeExport should make a backend call
func (s *Server) YoutubeExport(ctx context.Context, r *rpc.YoutubeExportRequest) (*rpc.YoutubeExportResponse, error) {
	err := s.backend.YoutubeExport(ctx, &models.YoutubeExportRequest{
		VodID:       utils.StrToInt64(r.VodId),
		Title:       r.Title,
		Description: r.Description,
		TagList:     r.TagList,
		Private:     r.Private,
		DoSplit:     r.DoSplit,
	})
	if err != nil {
		return nil, converters.ConvertToTwirpError(err, s.errorlogger)
	}
	return &rpc.YoutubeExportResponse{}, nil
}
