package server

import (
	"context"
	"errors"
	"testing"

	"code.justin.tv/vod/vodapi/internal/testdata"
	rpc "code.justin.tv/vod/vodapi/rpc/vodapi"
	"code.justin.tv/vod/vodapi/rpc/vodapi/utils"
	. "github.com/smartystreets/goconvey/convey"
	. "github.com/stretchr/testify/mock"
	"github.com/twitchtv/twirp"
)

func TestYoutubeExport(t *testing.T) {
	Convey("when calling YoutubeExport", t, func() {
		server, mocks := initTestableServer()
		ctx := context.Background()

		request := &rpc.YoutubeExportRequest{
			VodId:       utils.Int64ToStr(testdata.VodID1),
			Title:       "title",
			Description: "description",
			TagList:     []string{"tags"},
			Private:     true,
			DoSplit:     true,
		}

		Convey("when YoutubeExport succeeds", func() {
			mocks.backend.On("YoutubeExport", ctx, Anything).Return(nil)
			resp, err := server.YoutubeExport(ctx, request)
			So(err, ShouldBeNil)
			So(resp, ShouldNotBeNil)
		})
		Convey("when YoutubeExport fails", func() {
			mocks.MockTwirpErrorConvert()
			mocks.backend.On("YoutubeExport", ctx, Anything).Return(errors.New("something bad happened"))
			resp, err := server.YoutubeExport(ctx, request)
			So(resp, ShouldBeNil)
			So(err, ShouldBeError)
			twirpError := err.(twirp.Error)
			So(twirpError.Code(), ShouldEqual, twirp.Internal)
		})
		mocks.AssertExpectations(t)
	})
}
