package testdata

import "time"

const (
	// VodID1 is a vod id
	VodID1 = 1234
	// HearthstoneCommunity is a community
	HearthstoneCommunity = "136d5c6a-a7ed-4b6d-aedb-1deb08793157"
)

// GetTimeFromStringForTesting returns a time from string using RFC3339 format used for testing
func GetTimeFromStringForTesting(str string) time.Time {
	tm, err := time.Parse(time.RFC3339, str)
	if err != nil {
		return time.Time{}
	}
	return tm
}
