package testdata

import (
	"code.justin.tv/vod/vodapi/internal/backend/converters"
	"code.justin.tv/vod/vodapi/internal/models"
	"code.justin.tv/vod/vodapi/rpc/vodapi/utils"
)

// UploadVod returns mock data for internal Vod model of type upload
func UploadVod() *models.Vod {
	return converters.ConvertVinylVod(VinylUploadVod())
}

// ArchiveVod returns mock data for internal Vod model of type archive
func ArchiveVod() *models.Vod {
	return converters.ConvertVinylVod(VinylArchiveVod())
}

// MuteInfo is the mute info response
func MuteInfo() *models.VodMuteInfoResponse {
	vod := UploadVod()
	matchOffsetSeconds := int64(10)
	matchDurationSeconds := int64(20)
	scanOffsetSeconds := int64(30)
	scanDurationSeconds := int64(40)
	muteOffsetSeconds := int64(50)
	muteDurationSeconds := int64(60)

	audibleMagicResponses := []models.AudibleMagicResponse{
		models.AudibleMagicResponse{
			AudibleMagicResponseID: 1234,
			VodID:                vod.ID,
			Title:                *vod.Title,
			Performer:            "performer",
			Genre:                "genre",
			Artist:               "artist",
			AlbumTitle:           "album_title",
			Song:                 "song",
			Isrc:                 "isrc",
			IsMatch:              true,
			MatchOffsetSeconds:   &matchOffsetSeconds,
			MatchDurationSeconds: &matchDurationSeconds,
			ScanOffsetSeconds:    &scanOffsetSeconds,
			ScanDurationSeconds:  &scanDurationSeconds,
			MuteOffsetSeconds:    &muteOffsetSeconds,
			MuteDurationSeconds:  &muteDurationSeconds,
			AudibleMagicItemID:   "item_id",
			CreatedAt:            GetTimeFromStringForTesting("2018-06-26T07:39:34Z"),
			UnmutedAt:            utils.TimePtr(GetTimeFromStringForTesting("2018-06-26T07:39:34Z")),
		},
	}

	mutedSegments := []models.VodMutedSegment{
		models.VodMutedSegment{
			Offset:   5,
			Duration: 10,
		},
	}

	vodAppeal := models.VodAppeal{
		VodAppealID:    2345,
		ResolvedAt:     nil,
		CreatedAt:      GetTimeFromStringForTesting("2018-06-26T07:39:34Z"),
		UpdatedAt:      GetTimeFromStringForTesting("2018-06-26T07:39:34Z"),
		VodID:          vod.ID,
		Priority:       true,
		FullName:       "full_name",
		StreetAddress1: "street_address_1",
		StreetAddress2: "street_address_2",
		City:           "city",
		State:          "state",
		Zipcode:        "zipcode",
		Country:        "country",
	}

	trackAppeals := []models.TrackAppeal{
		models.TrackAppeal{
			TrackAppealID:          3456,
			AudibleMagicResponseID: 1234,
			VodAppealID:            2345,
			Reason:                 "reason",
			CreatedAt:              GetTimeFromStringForTesting("2018-06-26T07:39:34Z"),
			UpdatedAt:              GetTimeFromStringForTesting("2018-06-26T07:39:34Z"),
			ResolvedAt:             nil,
		},
	}

	isMuted := true
	canCreateAppeal := true
	hasPendingAppeal := false
	return &models.VodMuteInfoResponse{
		ID: 4444,
		AudibleMagicResponses: audibleMagicResponses,
		MutedSegments:         mutedSegments,
		VodAppeal:             vodAppeal,
		TrackAppeals:          trackAppeals,
		IsMuted:               &isMuted,
		CanCreateAppeal:       &canCreateAppeal,
		HasPendingAppeal:      &hasPendingAppeal,
	}
}

// VodAggregations is the vod aggregations response
func VodAggregations() *models.PublicVodAggregationsByIDsResponse {
	return &models.PublicVodAggregationsByIDsResponse{
		TotalCount:    100,
		TotalDuration: 1000,
	}
}

// VodPopularity is the vod popularity response
func VodPopularity() *models.VodPopularityResponse {
	return &models.VodPopularityResponse{
		Popular: true,
	}
}

// CreateThumbnailsResponse is the create thumbnails response
func CreateThumbnailsResponse() *models.CreateThumbnailsResponse {
	return &models.CreateThumbnailsResponse{
		Thumbnails: []models.Thumbnail{
			models.Thumbnail{
				Path: "path",
			},
		},
	}
}

// UserVideoPrivacyProperties is the user video privacy properties response
func UserVideoPrivacyProperties() *models.UserVideoPrivacyPropertiesResponse {
	return &models.UserVideoPrivacyPropertiesResponse{
		ChannelID:           1234,
		HideArchives:        true,
		HideArchivesEnabled: true,
		CreatedAt:           GetTimeFromStringForTesting("2018-06-26T07:39:34Z"),
		UpdatedAt:           GetTimeFromStringForTesting("2018-06-26T07:39:34Z"),
	}
}

// UserVodProperties is the user vod properties response
func UserVodProperties() *models.UserVodPropertiesResponse {
	return &models.UserVodPropertiesResponse{
		ChannelID:                1234,
		SaveVodsForever:          false,
		VodStorageDays:           100,
		CanUploadVod:             true,
		YoutubeExportingDisabled: false,
		SkipUploadModeration:     false,
		SkipMuting:               true,
		CanUploadUnlimited:       true,
		CreatedAt:                GetTimeFromStringForTesting("2018-06-26T07:39:34Z"),
		UpdatedAt:                GetTimeFromStringForTesting("2018-06-26T07:39:34Z"),
	}
}

// VodAppeals is the vod appeals response
func VodAppeals() *models.VodAppealsResponse {
	return &models.VodAppealsResponse{
		TotalCount: 1,
		Appeals: []models.VodAppeal{
			models.VodAppeal{
				VodAppealID:    7777,
				Priority:       true,
				VodID:          1234,
				City:           "city",
				Country:        "country",
				FullName:       "full_name",
				State:          "state",
				StreetAddress1: "street_address1",
				StreetAddress2: "street_address2",
				Zipcode:        "zipcode",
				CreatedAt:      GetTimeFromStringForTesting("2018-06-26T07:39:34Z"),
				UpdatedAt:      GetTimeFromStringForTesting("2018-06-26T07:39:34Z"),
			},
		},
	}
}

// AudibleMagicResponses is the audible magic responses
func AudibleMagicResponses() *models.AudibleMagicResponsesResponse {
	matchOffsetSeconds := int64(10)
	matchDurationSeconds := int64(20)
	scanOffsetSeconds := int64(30)
	scanDurationSeconds := int64(40)
	muteOffsetSeconds := int64(50)
	muteDurationSeconds := int64(60)

	return &models.AudibleMagicResponsesResponse{
		AudibleMagicResponses: []models.AudibleMagicResponse{
			models.AudibleMagicResponse{
				VodID:                VodID1,
				Title:                "title",
				Performer:            "performer",
				Genre:                "genre",
				Artist:               "artist",
				AlbumTitle:           "album_title",
				Song:                 "song",
				Isrc:                 "isrc",
				IsMatch:              true,
				MatchOffsetSeconds:   &matchOffsetSeconds,
				MatchDurationSeconds: &matchDurationSeconds,
				ScanOffsetSeconds:    &scanOffsetSeconds,
				ScanDurationSeconds:  &scanDurationSeconds,
				MuteOffsetSeconds:    &muteOffsetSeconds,
				MuteDurationSeconds:  &muteDurationSeconds,
				AudibleMagicItemID:   "audible_magic_item_id",
			},
		},
	}
}
