package testdata

import (
	vinyl "code.justin.tv/vod/vinyl/client"
	vinylWrapper "code.justin.tv/vod/vodapi/pkg/vinyl"
	"code.justin.tv/vod/vodapi/rpc/vodapi/utils"
)

// VinylUploadVod returns a vinyl vod mock data
func VinylUploadVod() *vinyl.Vod {
	return &vinyl.Vod{
		BroadcastID:         1,
		BroadcastType:       "upload",
		BroadcasterSoftware: nil,
		Communities: []string{
			"136d5c6a-a7ed-4b6d-aedb-1deb08793157",
		},
		CreatedAt:       GetTimeFromStringForTesting("2018-06-26T07:39:34Z"),
		CreatedBy:       utils.Int64Ptr(234210792),
		DeleteAt:        nil,
		Deleted:         nil,
		Description:     utils.StrPtr("Play Now ➜ https://putclokertv.com/tv/46896-the-originals/season-5/episode-10/\n\n♥♥♥♥♥♥♥♥♥♥♥♥♥♥♥♥♥♥♥♥♥♥♥♥♥♥♥♥♥♥♥♥♥♥♥♥♥♥♥♥♥♥♥♥♥♥♥♥♥♥♥♥♥♥\n\nThe Originals final season,\nThe Originals new season,\nThe Originals season 5 cast,\nThe Originals 123movies season 5,\nThe Originals season 5 part 10,\nwatch The Originals online,\nThe Originals season 5 episode 10,\nThe Originals season 5,\nThe Originals season premiere,\nThe Originals watch online,\nThe Originals norsk,\nThe Originals season 5 ep 10,\nThe Originals 5x10,\nThe Originals sesong 5 episode 10,\nThe Originals season 5 norge,\nThe Originals sesong 5,\nThe Originals season 5 online free,\nThe Originals 05x010,\nThe Originals season 5 stream,\nThe Originals norge,\nThe Originals 5x10 full episode,\nThe Originals 5 sezon 10 bolum,\nThe Originals season 5 online free,\nThe Originals 5x10 full episode,\nThe Originals sesong 5 episode 10,\nThe Originals season 5 stream,\nThe Originals 5x10,\nThe Originals 05x010,\nThe Originals season 5 ep 10,\nThe Originals 5.sezon 10. bolum,\nThe Originals norsk,\nThe Originals norge,\nThe Originals season 5 norge,\nThe Originals sesong 5,"),
		DescriptionHTML: utils.StrPtr("Play Now ➜ \u003ca href=\"https://putclokertv.com/tv/46896-the-originals/season-5/episode-10/\" rel=\"nofollow noreferrer noopener\" target=\"_blank\"\u003ehttps://putclokertv.com/tv/46896-the-originals/season-5/episode-10/\u003c/a\u003e\u003cbr\u003e\u003cbr\u003e♥♥♥♥♥♥♥♥♥♥♥♥♥♥♥♥♥♥♥♥♥♥♥♥♥♥♥♥♥♥♥♥♥♥♥♥♥♥♥♥♥♥♥♥♥♥♥♥♥♥♥♥♥♥\u003cbr\u003e\u003cbr\u003eThe Originals final season,\u003cbr\u003e\nThe Originals new season,\u003cbr\u003e\nThe Originals season 5 cast,\u003cbr\u003e\nThe Originals 123movies season 5,\u003cbr\u003e\nThe Originals season 5 part 10,\u003cbr\u003e\nwatch The Originals online,\u003cbr\u003e\nThe Originals season 5 episode 10,\u003cbr\u003e\nThe Originals season 5,\u003cbr\u003e\nThe Originals season premiere,\u003cbr\u003e\nThe Originals watch online,\u003cbr\u003e\nThe Originals norsk,\u003cbr\u003e\nThe Originals season 5 ep 10,\u003cbr\u003e\nThe Originals 5x10,\u003cbr\u003e\nThe Originals sesong 5 episode 10,\u003cbr\u003e\nThe Originals season 5 norge,\u003cbr\u003e\nThe Originals sesong 5,\u003cbr\u003e\nThe Originals season 5 online free,\u003cbr\u003e\nThe Originals 05x010,\u003cbr\u003e\nThe Originals season 5 stream,\u003cbr\u003e\nThe Originals norge,\u003cbr\u003e\nThe Originals 5x10 full episode,\u003cbr\u003e\nThe Originals 5 sezon 10 bolum,\u003cbr\u003e\nThe Originals season 5 online free,\u003cbr\u003e\nThe Originals 5x10 full episode,\u003cbr\u003e\nThe Originals sesong 5 episode 10,\u003cbr\u003e\nThe Originals season 5 stream,\u003cbr\u003e\nThe Originals 5x10,\u003cbr\u003e\nThe Originals 05x010,\u003cbr\u003e\nThe Originals season 5 ep 10,\u003cbr\u003e\nThe Originals 5.sezon 10. bolum,\u003cbr\u003e\nThe Originals norsk,\u003cbr\u003e\nThe Originals norge,\u003cbr\u003e\nThe Originals season 5 norge,\u003cbr\u003e\nThe Originals sesong 5,\u003cbr\u003e"),
		Duration:        3535,
		Fps: map[string]float64{
			"144p30": 24.865913409564175,
			"360p30": 24.865913409564175,
		},
		Game:     utils.StrPtr("League of Legends"),
		ID:       277731474,
		Language: utils.StrPtr("en"),
		Manifest: utils.StrPtr("index-dvr.m3u8"),
		Offset:   0,
		Origin:   utils.StrPtr("s3"),
		OwnerID:  234210792,
		Resolutions: map[string]string{
			"144p30": "256x144",
			"360p30": "640x360",
		},
		SourceArchiveID:  nil,
		StartedOn:        GetTimeFromStringForTesting("2018-06-26T07:39:34Z"),
		Status:           "recorded",
		TagList:          "",
		Title:            utils.StrPtr("The Originals (Se.05 Ep.10) Season 5 Episode 10 Full Watch"),
		TotalLength:      3535,
		UpdatedAt:        GetTimeFromStringForTesting("2018-06-28T07:36:14Z"),
		URI:              "sojon_jono/277731474/fc00be67-436f-41ed-9178-8dab6b5bb283",
		Viewable:         utils.StrPtr("public"),
		ViewableAt:       nil,
		Views:            322,
		PublishedAt:      utils.TimePtr(GetTimeFromStringForTesting("2018-06-28T07:36:14Z")),
		IncrementViewURL: "https://countess.twitch.tv/ping.gif?u=%7B%22id%22%3A%22277731474%22%2C%22type%22%3A%22vod%22%7D",
		Qualities: []string{
			"144p30",
			"360p30",
			"audio_only",
		},
		PreviewTemplate: "https://static-cdn.jtvnw.net/s3_vods/sojon_jono/277731474/fc00be67-436f-41ed-9178-8dab6b5bb283/thumb/custom-5ad441c7-63f0-40c1-a3e0-a6a929dca04d-%{width}x%{height}.jpg",
		ShowFormats: map[string]map[string]interface{}{
			"144p30": map[string]interface{}{
				"bitrate":      255712,
				"codecs":       "avc1.4D400C,mp4a.40.2",
				"display_name": "144p",
				"fps":          24.865913409564175,
				"playlist_preference": 6,
				"resolution":          "256x144",
			},
			"360p30": map[string]interface{}{
				"bitrate":      590888,
				"codecs":       "avc1.4D401E,mp4a.40.2",
				"display_name": "360p",
				"fps":          24.865913409564175,
				"playlist_preference": 5,
				"resolution":          "640x360",
			},
			"audio_only": map[string]interface{}{
				"bitrate":             144128,
				"codecs":              "mp4a.40.2",
				"display_name":        "Audio Only",
				"playlist_preference": 6,
			},
		},
		ThumbnailTemplates: vinyl.ThumbnailTemplateList{
			vinyl.ThumbnailTemplate{
				Path: "custom-5ad441c7-63f0-40c1-a3e0-a6a929dca04d.jpg",
				Type: "custom",
				URL:  "https://static-cdn.jtvnw.net/s3_vods/sojon_jono/277731474/fc00be67-436f-41ed-9178-8dab6b5bb283/thumb/custom-5ad441c7-63f0-40c1-a3e0-a6a929dca04d-%{width}x%{height}.jpg",
			},
			vinyl.ThumbnailTemplate{
				Offset: 62940,
				Path:   "thumb/index-0000000000.jpg",
				Type:   "generated",
				URL:    "https://static-cdn.jtvnw.net/s3_vods/sojon_jono/277731474/fc00be67-436f-41ed-9178-8dab6b5bb283/thumb/index-0000000000-%{width}x%{height}.jpg",
			},
			vinyl.ThumbnailTemplate{
				Offset: 1142965,
				Path:   "thumb/index-0000000009.jpg",
				Type:   "generated",
				URL:    "https://static-cdn.jtvnw.net/s3_vods/sojon_jono/277731474/fc00be67-436f-41ed-9178-8dab6b5bb283/thumb/index-0000000009-%{width}x%{height}.jpg",
			},
			vinyl.ThumbnailTemplate{
				Offset: 2222951,
				Path:   "thumb/index-0000000018.jpg",
				Type:   "generated",
				URL:    "https://static-cdn.jtvnw.net/s3_vods/sojon_jono/277731474/fc00be67-436f-41ed-9178-8dab6b5bb283/thumb/index-0000000018-%{width}x%{height}.jpg",
			},
			vinyl.ThumbnailTemplate{
				Offset: 3302936,
				Path:   "thumb/index-0000000027.jpg",
				Type:   "generated",
				URL:    "https://static-cdn.jtvnw.net/s3_vods/sojon_jono/277731474/fc00be67-436f-41ed-9178-8dab6b5bb283/thumb/index-0000000027-%{width}x%{height}.jpg",
			},
		},
		SeekPreviewsURL:    "https://vod-storyboards.twitch.tv/sojon_jono/277731474/fc00be67-436f-41ed-9178-8dab6b5bb283/storyboards/277731474-info.json",
		AnimatedPreviewURL: "https://vod-storyboards.twitch.tv/sojon_jono/277731474/fc00be67-436f-41ed-9178-8dab6b5bb283/storyboards/277731474-strip-0.jpg",
		Path:               "/videos/277731474",
		URL:                "https://www.twitch.tv/videos/277731474",
	}
}

// VinylArchiveVod returns vinyl Vod mock data
func VinylArchiveVod() *vinyl.Vod {
	return &vinyl.Vod{
		BroadcastID:         29548428016,
		BroadcastType:       "archive",
		BroadcasterSoftware: utils.StrPtr("unknown_rtmp"),
		Communities: []string{
			"ec04cef0-0e81-4fa9-a037-d11ac87051b6",
			"fd0eab99-832a-4d7e-8cc0-04d73deb2e54",
			"ff1e77af-551d-4993-945c-f8ceaa2a2829",
		},
		CreatedAt:       utils.StubTimeNow(),
		CreatedBy:       utils.Int64Ptr(136992160),
		DeleteAt:        nil,
		Deleted:         nil,
		Description:     nil,
		DescriptionHTML: nil,
		Duration:        0,
		Fps: map[string]float64{
			"160p30":     30,
			"360p30":     30,
			"480p30":     30,
			"720p30":     30,
			"audio_only": 0,
			"chunked":    26,
		},
		Game:     utils.StrPtr("Music"),
		ID:       286681909,
		Language: utils.StrPtr("en"),
		Manifest: utils.StrPtr("index-dvr.m3u8"),
		Offset:   0,
		Origin:   utils.StrPtr("s3"),
		OwnerID:  136992160,
		Resolutions: map[string]string{
			"160p30":  "284x160",
			"360p30":  "640x360",
			"480p30":  "852x480",
			"720p30":  "1280x720",
			"chunked": "1920x1080",
		},
		SourceArchiveID:  nil,
		StartedOn:        utils.StubTimeNow(),
		Status:           "recording",
		TagList:          "",
		Title:            utils.StrPtr("Positive Quote: Most smiles are started by another smile. #PosiLIVIty 🌻"),
		TotalLength:      7533,
		UpdatedAt:        utils.StubTimeNow(),
		URI:              "238246383b16112fe121_livi_in_the_middle_29548428016_915446914",
		Viewable:         utils.StrPtr("public"),
		ViewableAt:       nil,
		Views:            0,
		PublishedAt:      utils.TimePtr(utils.StubTimeNow()),
		IncrementViewURL: "https://countess.twitch.tv/ping.gif?u=%7B%22id%22%3A%22286681909%22%2C%22type%22%3A%22vod%22%7D",
		Qualities: []string{
			"160p30",
			"360p30",
			"480p30",
			"720p30",
			"audio_only",
			"chunked",
		},
		PreviewTemplate: "https://static-cdn.jtvnw.net/s3_vods/238246383b16112fe121_livi_in_the_middle_29548428016_915446914/thumb/thumb0-%{width}x%{height}.jpg",
		ShowFormats: map[string]map[string]interface{}{
			"160p30": map[string]interface{}{
				"bitrate":             230000,
				"codecs":              "avc1.4D400C,mp4a.40.2",
				"display_name":        "160p30",
				"fps":                 30,
				"max_idr_interval":    0,
				"playlist_preference": 6,
				"resolution":          "284x160",
			},
			"360p30": map[string]interface{}{
				"bitrate":             630000,
				"codecs":              "avc1.4D401E,mp4a.40.2",
				"display_name":        "360p30",
				"fps":                 30,
				"max_idr_interval":    0,
				"playlist_preference": 5,
				"resolution":          "640x360",
			},
			"480p30": map[string]interface{}{
				"bitrate":             1200000,
				"codecs":              "avc1.4D401E,mp4a.40.2",
				"display_name":        "480p30",
				"fps":                 30,
				"max_idr_interval":    0,
				"playlist_preference": 4,
				"resolution":          "852x480",
			},
			"720p30": map[string]interface{}{
				"bitrate":             2100000,
				"codecs":              "avc1.4D401F,mp4a.40.2",
				"display_name":        "720p30",
				"fps":                 30,
				"max_idr_interval":    0,
				"playlist_preference": 3,
				"resolution":          "1280x720",
			},
			"audio_only": map[string]interface{}{
				"bitrate":             161582,
				"codecs":              "mp4a.40.2",
				"display_name":        "Audio Only",
				"fps":                 0,
				"max_idr_interval":    0,
				"playlist_preference": 5,
			},
			"chunked": map[string]interface{}{
				"bitrate":             2916316,
				"codecs":              "avc1.640028,mp4a.40.2",
				"display_name":        "Source",
				"fps":                 26,
				"max_idr_interval":    2000,
				"playlist_preference": 0,
				"resolution":          "1920x1080",
			},
		},
		ThumbnailTemplates: vinyl.ThumbnailTemplateList{
			vinyl.ThumbnailTemplate{
				Offset: 13.868164,
				Path:   "thumb/thumb0.jpg",
				Type:   "generated",
				URL:    "https://static-cdn.jtvnw.net/s3_vods/238246383b16112fe121_livi_in_the_middle_29548428016_915446914/thumb/thumb0-%{width}x%{height}.jpg",
			},
			vinyl.ThumbnailTemplate{
				Offset: 43.85984,
				Path:   "thumb/thumb1.jpg",
				Type:   "generated",
				URL:    "https://static-cdn.jtvnw.net/s3_vods/238246383b16112fe121_livi_in_the_middle_29548428016_915446914/thumb/thumb1-%{width}x%{height}.jpg",
			},
			vinyl.ThumbnailTemplate{
				Offset: 73.82859,
				Path:   "thumb/thumb2.jpg",
				Type:   "generated",
				URL:    "https://static-cdn.jtvnw.net/s3_vods/238246383b16112fe121_livi_in_the_middle_29548428016_915446914/thumb/thumb2-%{width}x%{height}.jpg",
			},
			vinyl.ThumbnailTemplate{
				Offset: 103.8104,
				Path:   "thumb/thumb3.jpg",
				Type:   "generated",
				URL:    "https://static-cdn.jtvnw.net/s3_vods/238246383b16112fe121_livi_in_the_middle_29548428016_915446914/thumb/thumb3-%{width}x%{height}.jpg",
			},
		},
		SeekPreviewsURL:    "https://vod-storyboards.twitch.tv/238246383b16112fe121_livi_in_the_middle_29548428016_915446914/storyboards/286681909-info.json",
		AnimatedPreviewURL: "https://vod-storyboards.twitch.tv/238246383b16112fe121_livi_in_the_middle_29548428016_915446914/storyboards/286681909-strip-0.jpg",
		Path:               "/videos/286681909",
		URL:                "https://www.twitch.tv/videos/286681909",
	}
}

// VinylCreateThumbnailsOutput returns vinly create thumbnails output
func VinylCreateThumbnailsOutput() *vinyl.CreateThumbnailsOutput {
	return &vinyl.CreateThumbnailsOutput{
		Thumbnails: []*vinyl.Thumbnail{
			&vinyl.Thumbnail{
				Path: "path",
			},
		},
	}
}

// VinylUserVodProperties returns vinly user vod properties
func VinylUserVodProperties() *vinyl.UserVODProperties {
	return &vinyl.UserVODProperties{
		UserID:                   1234,
		SaveVODsForever:          false,
		VODStorageDays:           100,
		CanUploadVOD:             true,
		YoutubeExportingDisabled: false,
		SkipUploadModeration:     false,
		SkipMuting:               true,
		CanUploadUnlimited:       true,
		CreatedAt:                GetTimeFromStringForTesting("2018-07-19T19:00:10Z"),
		UpdatedAt:                GetTimeFromStringForTesting("2018-07-19T19:00:10Z"),
	}
}

// VinylUserVideoPrivacyProperties returns vinly user video privacy properties
func VinylUserVideoPrivacyProperties() *vinyl.UserVideoPrivacyProperties {
	return &vinyl.UserVideoPrivacyProperties{
		UserID:              1234,
		HideArchives:        true,
		HideArchivesEnabled: true,
		CreatedAt:           GetTimeFromStringForTesting("2018-07-19T19:00:10Z"),
		UpdatedAt:           GetTimeFromStringForTesting("2018-07-19T19:00:10Z"),
	}
}

// VinylAppeals returns vinyl appeals
func VinylAppeals() *vinylWrapper.GetAppealsResponse {
	return &vinylWrapper.GetAppealsResponse{
		Appeals: []vinylWrapper.Appeal{
			vinylWrapper.Appeal{
				ID:             5678,
				CreatedAt:      GetTimeFromStringForTesting("2018-07-19T19:00:10Z"),
				UpdatedAt:      GetTimeFromStringForTesting("2018-07-19T19:00:10Z"),
				VodID:          VodID1,
				Priority:       true,
				FullName:       "full_name",
				StreetAddress1: "street_address1",
				StreetAddress2: "street_address1",
				City:           "city",
				State:          "state",
				Zipcode:        "zipcode",
				Country:        "country",
			},
		},
	}
}

// VinylAudibleMagicResponses returns vinyl audible magic responses
func VinylAudibleMagicResponses() []*vinyl.AMR {
	title := "title"
	performer := "performer"
	genre := "genre"
	artist := "artist"
	albumTitle := "album_title"
	song := "song"
	isrc := "isrc"
	matchOffsetSeconds := int64(10)
	matchDurationSeconds := int64(20)
	scanOffsetSeconds := int64(30)
	scanDurationSeconds := int64(40)
	muteOffsetSeconds := int64(50)
	muteDurationSeconds := int64(60)
	audibleMagicItemID := "audible_magic_item_id"
	return []*vinyl.AMR{
		&vinyl.AMR{
			VodID:                VodID1,
			Title:                &title,
			Performer:            &performer,
			Genre:                &genre,
			Artist:               &artist,
			AlbumTitle:           &albumTitle,
			Song:                 &song,
			Isrc:                 &isrc,
			IsMatch:              true,
			MatchOffsetSeconds:   &matchOffsetSeconds,
			MatchDurationSeconds: &matchDurationSeconds,
			ScanOffsetSeconds:    &scanOffsetSeconds,
			ScanDurationSeconds:  &scanDurationSeconds,
			MuteOffsetSeconds:    &muteOffsetSeconds,
			MuteDurationSeconds:  &muteDurationSeconds,
			AmItemID:             &audibleMagicItemID,
		},
	}
}
