package shared

import (
	"golang.org/x/net/context"
)

type contextKey string

var (
	userIDContextKey = contextKey("user-id")
	authToken        = contextKey("auth.authToken")
)

// UserIDFromContext returns the user ID from a context variable
func UserIDFromContext(ctx context.Context) (string, bool) {
	userID, ok := ctx.Value(userIDContextKey).(string)
	return userID, ok
}

// AuthorizationTokenFromContext gets auth token from context
func AuthorizationTokenFromContext(ctx context.Context) string {
	if authToken, ok := ctx.Value(authToken).(string); ok {
		return authToken
	}
	return ""
}

// ContextWithUser returns a context with user ID stored in it
func ContextWithUser(ctx context.Context, userID string) context.Context {
	return context.WithValue(ctx, userIDContextKey, userID)
}

// ContextWithAuthToken returns a context with authorization token stored in it
func ContextWithAuthToken(ctx context.Context, t string) context.Context {
	return context.WithValue(ctx, authToken, t)
}
