package vinyl

import (
	"time"

	vinylclient "code.justin.tv/vod/vinyl/client"
)

// createUploadWrapper is used to wrap request / response vod
type createUploadWrapper struct {
	Vod CreateUploadVod `json:"vod"`
}

// CreateUploadVod is the CreateVod endpoint.
type CreateUploadVod struct {
	BroadcastID    int64      `json:"broadcast_id"`
	BroadcastType  string     `json:"broadcast_type"`
	Title          string     `json:"title"`
	Description    string     `json:"description"`
	Duration       int64      `json:"duration"`
	URI            string     `json:"uri"`
	Manifest       string     `json:"manifest"`
	Game           string     `json:"game"`
	Communities    []string   `json:"communities"`
	TagList        string     `json:"tag_list"`
	Language       string     `json:"language"`
	Viewable       string     `json:"viewable"`
	ViewableAt     *time.Time `json:"viewable_at"`
	CreatePremiere bool       `json:"create_premiere"`
	OwnerID        int64      `json:"owner_id"`
	Status         string     `json:"status"`
}

type createVodResponse struct {
	Vod vinylclient.Vod `json:"vod"`
}

type createArchiveWrapper struct {
	Vod CreateArchiveVod `json:"vod"`
}

// CreateArchiveVod is the CreateArchive input
type CreateArchiveVod struct {
	BroadcastID         int64                             `json:"broadcast_id"`
	BroadcastType       string                            `json:"broadcast_type"`
	BroadcasterSoftware *string                           `json:"broadcaster_software"`
	StartedOn           time.Time                         `json:"recorded_on"`
	Status              string                            `json:"status"`
	Title               string                            `json:"title"`
	OwnerID             int64                             `json:"owner_id"`
	ShowFormats         map[string]map[string]interface{} `json:"show_formats"`
	Offset              int                               `json:"offset"`
	Duration            int                               `json:"duration"`
	URI                 string                            `json:"uri"`
	Origin              *string                           `json:"origin"`
	Manifest            *string                           `json:"manifest"`
	Deleted             *bool                             `json:"deleted"`
	HandwaveLatencyMS   *int64                            `json:"handwave_latency_ms"`
}

// internalCreateHighlightWrapper is used to wrap request / response vod
type internalCreateHighlightWrapper struct {
	Vod InternalCreateHighlightVod `json:"vod"`
}

// InternalCreateHighlightVod is the CreateVod endpoint.
type InternalCreateHighlightVod struct {
	SourceArchiveID int64                             `json:"source_archive_id"`
	OwnerID         int64                             `json:"owner_id"`
	URI             string                            `json:"uri"`
	BroadcastID     int64                             `json:"broadcast_id"`
	ShowFormats     map[string]map[string]interface{} `json:"show_formats"`
	Title           string                            `json:"title"`
	Duration        int64                             `json:"duration"`
	BroadcastType   string                            `json:"broadcast_type"`
	Status          string                            `json:"status"`
}

type vodsResponse struct {
	Vods []*vinylclient.Vod `json:"vods"`
}

// GetVodsByUserIncludeBannedUsersInput is the get request
type GetVodsByUserIncludeBannedUsersInput struct {
	ChannelID     string `json:"channel_id"`
	BroadcastType string `json:"broadcast_type"`
	Limit         int64  `json:"limit"`
	Offset        int64  `json:"offset"`
}

// SetViewcountsUpdate is the set viewcounts update
type SetViewcountsUpdate struct {
	VodID int64 `json:"vod_id"`
	Count int64 `json:"count"`
}

// SetViewcountsInput is the set viewcounts request
type SetViewcountsInput struct {
	Viewcounts []SetViewcountsUpdate `json:"view_counts"`
}

// UpdateUserVodPropertiesInput is the update user vod properties request
type UpdateUserVodPropertiesInput struct {
	ChannelID                string `json:"channel_id"`
	SaveVodsForever          *bool  `json:"save_vods_forever,omitempty"`
	VodStorageDays           *int64 `json:"vod_storage_days,omitempty"`
	CanUploadVod             *bool  `json:"can_upload_vod,omitempty"`
	YoutubeExportingDisabled *bool  `json:"youtube_exporting_disabled,omitempty"`
	SkipUploadModeration     *bool  `json:"skip_upload_moderation,omitempty"`
	SkipMuting               *bool  `json:"skip_muting,omitempty"`
	CanUploadUnlimited       *bool  `json:"can_upload_unlimited,omitempty"`
}

// GetAppealsInput is the get appeals request
type GetAppealsInput struct {
	Priority *bool  `json:"priority"`
	Resolved *bool  `json:"resolved"`
	Limit    int64  `json:"limit"`
	Offset   int64  `json:"offset"`
	VodID    string `json:"vod_id"`
	UserInfo string `json:"string"`
}

// Appeal is the appeal response
type Appeal struct {
	ID             int64      `json:"id"`
	ResolvedAt     *time.Time `json:"resolved_at"`
	CreatedAt      time.Time  `json:"created_at"`
	UpdatedAt      time.Time  `json:"updated_at"`
	VodID          int64      `json:"vod_id"`
	Priority       bool       `json:"priority"`
	FullName       string     `json:"full_name"`
	StreetAddress1 string     `json:"street_address_1"`
	StreetAddress2 string     `json:"street_address_2"`
	City           string     `json:"city"`
	State          string     `json:"state"`
	Zipcode        string     `json:"zipcode"`
	Country        string     `json:"country"`
}

// GetAppealsResponse is the get appeals response
type GetAppealsResponse struct {
	Appeals    []Appeal `json:"appeals"`
	TotalCount int64    `json:"total_count"`
}

// UpdateAudibleMagicResponse is the update audible magic response
type UpdateAudibleMagicResponse struct {
	AudibleMagicResponseID int64   `json:"-"`
	Title                  *string `json:"title,omitempty"`
	Performer              *string `json:"performer,omitempty"`
	Genre                  *string `json:"genre,omitempty"`
	Artist                 *string `json:"artist,omitempty"`
	AlbumTitle             *string `json:"album_title,omitempty"`
	Song                   *string `json:"song,omitempty"`
	Isrc                   *string `json:"isrc,omitempty"`
	IsMatch                bool    `json:"is_match"`
	MatchOffsetSeconds     *int64  `json:"match_offset_seconds,omitempty"`
	MatchDurationSeconds   *int64  `json:"match_duration_seconds,omitempty"`
	ScanOffsetSeconds      *int64  `json:"scan_offset_seconds,omitempty"`
	ScanDurationSeconds    *int64  `json:"scan_duration_seconds,omitempty"`
	MuteOffsetSeconds      *int64  `json:"mute_offset_seconds"`
	MuteDurationSeconds    *int64  `json:"mute_duration_seconds"`
	AmItemID               *string `json:"am_item_id,omitempty"`
}

// UpdateAudibleMagicResponsesInput is the update audible magic responses input
type UpdateAudibleMagicResponsesInput struct {
	UpdateAudibleMagicResponses []UpdateAudibleMagicResponse `json:"update_audible_magic_responses"`
}
