// Code generated by protoc-gen-go. DO NOT EDIT.
// source: responses.proto

/*
Package vodapi is a generated protocol buffer package.

It is generated from these files:
	responses.proto
	requests.proto
	service.proto
	consts.proto

It has these top-level messages:
	ShowFormat
	Thumbnail
	ThumbnailTemplate
	AudibleMagicResponse
	VodMutedSegment
	VodAppeal
	TrackAppeal
	VodNotificationSetting
	VodNotificationSettingsMap
	Vod
	CreateUploadResponse
	CreateArchiveResponse
	InternalCreateHighlightResponse
	ManagerCreateHighlightResponse
	PublicGetVodByIDResponse
	InternalGetVodByIDResponse
	ManagerInternalGetVodByIDResponse
	VodMuteInfoResponse
	ManagerGetVodMuteInfoResponse
	InternalGetVodMuteInfoResponse
	ManagerGetVodMuteInfosResponse
	GetVodByIDIncludeBannedUsersResponse
	ManagerGetVodByIDResponse
	ManagerSearchVodsResponse
	PublicGetVodsByUserResponse
	ManagerInternalGetVodsByUserResponse
	ManagerGetVodsByUserIncludeBannedUsersResponse
	InternalGetVodsByBroadcastIDsResponse
	PublicGetVodsByIDsResponse
	InternalGetVodsByIDsResponse
	GetVodsByIDsIncludeBannedUsersResponse
	PublicGetVodsByUsersResponse
	GetTopVodsResponse
	ManagerUpdateVodResponse
	UndeleteVodsResponse
	SoftDeleteVodsResponse
	InternalVodRemoveRecordsResponse
	HardDeleteVodsResponse
	SoftDeleteVodsInIntervalResponse
	ManagerSoftDeleteVodsResponse
	YoutubeExportResponse
	FinalizeUploadResponse
	UpdateManifestResponse
	SetViewcountsResponse
	PublicVodAggregationsByIDsResponse
	VodPopularityResponse
	CreateErrorResponse
	CreateThumbnailsResponse
	CreateCustomThumbnailUploadRequestResponse
	ManagerDeleteThumbnailsResponse
	DeleteThumbnailsResponse
	UserVodPropertiesResponse
	UserVideoPrivacyPropertiesResponse
	CreateVodAppealsResponse
	VodAppealsResponse
	ResolveTrackAppealResponse
	ResolveVodAppealResponse
	AudibleMagicResponsesResponse
	CreateUploadRequest
	ShowFormatRequest
	CreateArchiveRequest
	InternalCreateHighlightRequest
	ManagerCreateHighlightRequest
	PublicGetVodByIDRequest
	InternalGetVodByIDRequest
	ManagerInternalGetVodByIDRequest
	ManagerGetVodMuteInfoRequest
	InternalGetVodMuteInfoRequest
	ManagerGetVodMuteInfosRequest
	GetVodByIDIncludeBannedUsersRequest
	ManagerGetVodByIDRequest
	ManagerSearchVodsRequest
	PublicGetVodsByUserRequest
	ManagerInternalGetVodsByUserRequest
	ManagerGetVodsByUserIncludeBannedUsersRequest
	InternalGetVodsByBroadcastIDsRequest
	PublicGetVodsByIDsRequest
	InternalGetVodsByIDsRequest
	GetVodsByIDsIncludeBannedUsersRequest
	PublicGetVodsByUsersRequest
	GetTopVodsRequest
	ThumbnailRequest
	ManagerUpdateVodRequest
	UndeleteVodsRequest
	SoftDeleteVodsRequest
	InternalVodRemoveRecordsRequest
	HardDeleteVodsRequest
	SoftDeleteVodsInIntervalRequest
	ManagerSoftDeleteVodsRequest
	YoutubeExportRequest
	FinalizeUploadRequest
	UpdateManifestRequest
	ViewcountsUpdate
	SetViewcountsRequest
	GetPublicVodAggregationsByIDsRequest
	GetVodPopularityRequest
	CreateErrorRequest
	CreateThumbnailsRequest
	ManagerCreateCustomThumbnailUploadRequestRequest
	ManagerDeleteThumbnailsRequest
	DeleteThumbnailsRequest
	ManagerGetUserVodPropertiesRequest
	ManagerUpdateUserVodPropertiesRequest
	ManagerGetUserVideoPrivacyPropertiesRequest
	ManagerUpdateUserVideoPrivacyPropertiesRequest
	TrackAppealRequest
	ManagerCreateVodAppealsRequest
	GetVodAppealsRequest
	ResolveTrackAppealRequest
	ResolveVodAppealRequest
	CreateAudibleMagicResponseRequest
	CreateAudibleMagicResponsesRequest
	GetAudibleMagicResponsesRequest
	UpdateAudibleMagicResponseRequest
	UpdateAudibleMagicResponsesRequest
*/
package vodapi

import proto "github.com/golang/protobuf/proto"
import fmt "fmt"
import math "math"
import google_protobuf "github.com/golang/protobuf/ptypes/wrappers"
import google_protobuf1 "github.com/golang/protobuf/ptypes/timestamp"

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.ProtoPackageIsVersion2 // please upgrade the proto package

type ShowFormat struct {
	// playlist_preference is an index into the formats for order to play the formats
	PlaylistPreference int64 `protobuf:"varint,1,opt,name=playlist_preference,json=playlistPreference" json:"playlist_preference,omitempty"`
	// display_name is the display name of the format
	DisplayName string `protobuf:"bytes,2,opt,name=display_name,json=displayName" json:"display_name,omitempty"`
	// bitrate is the bitrate of the format
	Bitrate int64 `protobuf:"varint,3,opt,name=bitrate" json:"bitrate,omitempty"`
	// fps is the frames per second of the format
	Fps float64 `protobuf:"fixed64,4,opt,name=fps" json:"fps,omitempty"`
	// max_idr_interval is the max idr interval for the format
	MaxIdrInterval int64 `protobuf:"varint,5,opt,name=max_idr_interval,json=maxIdrInterval" json:"max_idr_interval,omitempty"`
	// codecs is the list of codecs related to this format
	Codecs string `protobuf:"bytes,6,opt,name=codecs" json:"codecs,omitempty"`
	// resolution is the resolution of the format
	Resolution string `protobuf:"bytes,7,opt,name=resolution" json:"resolution,omitempty"`
}

func (m *ShowFormat) Reset()                    { *m = ShowFormat{} }
func (m *ShowFormat) String() string            { return proto.CompactTextString(m) }
func (*ShowFormat) ProtoMessage()               {}
func (*ShowFormat) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{0} }

func (m *ShowFormat) GetPlaylistPreference() int64 {
	if m != nil {
		return m.PlaylistPreference
	}
	return 0
}

func (m *ShowFormat) GetDisplayName() string {
	if m != nil {
		return m.DisplayName
	}
	return ""
}

func (m *ShowFormat) GetBitrate() int64 {
	if m != nil {
		return m.Bitrate
	}
	return 0
}

func (m *ShowFormat) GetFps() float64 {
	if m != nil {
		return m.Fps
	}
	return 0
}

func (m *ShowFormat) GetMaxIdrInterval() int64 {
	if m != nil {
		return m.MaxIdrInterval
	}
	return 0
}

func (m *ShowFormat) GetCodecs() string {
	if m != nil {
		return m.Codecs
	}
	return ""
}

func (m *ShowFormat) GetResolution() string {
	if m != nil {
		return m.Resolution
	}
	return ""
}

type Thumbnail struct {
	// path is the path of the thumbnail
	Path string `protobuf:"bytes,1,opt,name=path" json:"path,omitempty"`
	// offset is the offset into the thumbnail
	Offset *google_protobuf.DoubleValue `protobuf:"bytes,2,opt,name=offset" json:"offset,omitempty"`
}

func (m *Thumbnail) Reset()                    { *m = Thumbnail{} }
func (m *Thumbnail) String() string            { return proto.CompactTextString(m) }
func (*Thumbnail) ProtoMessage()               {}
func (*Thumbnail) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{1} }

func (m *Thumbnail) GetPath() string {
	if m != nil {
		return m.Path
	}
	return ""
}

func (m *Thumbnail) GetOffset() *google_protobuf.DoubleValue {
	if m != nil {
		return m.Offset
	}
	return nil
}

type ThumbnailTemplate struct {
	// offset is the offset into the thumbnail
	Offset float64 `protobuf:"fixed64,1,opt,name=offset" json:"offset,omitempty"`
	// path is the path of the thumbnail
	Path string `protobuf:"bytes,2,opt,name=path" json:"path,omitempty"`
	// type is whether the thumbnail is generated or custom
	Type VodThumbnailType `protobuf:"varint,3,opt,name=type,enum=vodapi.VodThumbnailType" json:"type,omitempty"`
	// url is the url path to the thumbnail
	Url string `protobuf:"bytes,4,opt,name=url" json:"url,omitempty"`
}

func (m *ThumbnailTemplate) Reset()                    { *m = ThumbnailTemplate{} }
func (m *ThumbnailTemplate) String() string            { return proto.CompactTextString(m) }
func (*ThumbnailTemplate) ProtoMessage()               {}
func (*ThumbnailTemplate) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{2} }

func (m *ThumbnailTemplate) GetOffset() float64 {
	if m != nil {
		return m.Offset
	}
	return 0
}

func (m *ThumbnailTemplate) GetPath() string {
	if m != nil {
		return m.Path
	}
	return ""
}

func (m *ThumbnailTemplate) GetType() VodThumbnailType {
	if m != nil {
		return m.Type
	}
	return VodThumbnailType_INVALID_THUMBNAIL_TYPE
}

func (m *ThumbnailTemplate) GetUrl() string {
	if m != nil {
		return m.Url
	}
	return ""
}

type AudibleMagicResponse struct {
	// audible_magic_response_id is the audible magic response id
	AudibleMagicResponseId string `protobuf:"bytes,1,opt,name=audible_magic_response_id,json=audibleMagicResponseId" json:"audible_magic_response_id,omitempty"`
	// vod_id is the id of the vod that this audible magic response request is for
	VodId string `protobuf:"bytes,2,opt,name=vod_id,json=vodId" json:"vod_id,omitempty"`
	// title is the amr title
	Title string `protobuf:"bytes,3,opt,name=title" json:"title,omitempty"`
	// performer is the amr performer
	Performer string `protobuf:"bytes,4,opt,name=performer" json:"performer,omitempty"`
	// genre is the amr genre
	Genre string `protobuf:"bytes,5,opt,name=genre" json:"genre,omitempty"`
	// artist is the amr artist
	Artist string `protobuf:"bytes,6,opt,name=artist" json:"artist,omitempty"`
	// album_title is the amr album title
	AlbumTitle string `protobuf:"bytes,7,opt,name=album_title,json=albumTitle" json:"album_title,omitempty"`
	// song is the amr song
	Song string `protobuf:"bytes,8,opt,name=song" json:"song,omitempty"`
	// isrc is the amr isrc
	Isrc string `protobuf:"bytes,9,opt,name=isrc" json:"isrc,omitempty"`
	// is_match is whether there is a match for this amr
	IsMatch bool `protobuf:"varint,10,opt,name=is_match,json=isMatch" json:"is_match,omitempty"`
	// match_offset_seconds is the match offset into the vod
	MatchOffsetSeconds *google_protobuf.Int64Value `protobuf:"bytes,11,opt,name=match_offset_seconds,json=matchOffsetSeconds" json:"match_offset_seconds,omitempty"`
	// match_duration_seconds is the match duration
	MatchDurationSeconds *google_protobuf.Int64Value `protobuf:"bytes,12,opt,name=match_duration_seconds,json=matchDurationSeconds" json:"match_duration_seconds,omitempty"`
	// scan_offset_seconds is the scan offset into the vod
	ScanOffsetSeconds *google_protobuf.Int64Value `protobuf:"bytes,13,opt,name=scan_offset_seconds,json=scanOffsetSeconds" json:"scan_offset_seconds,omitempty"`
	// scan_duration_seconds is the scan duration
	ScanDurationSeconds *google_protobuf.Int64Value `protobuf:"bytes,14,opt,name=scan_duration_seconds,json=scanDurationSeconds" json:"scan_duration_seconds,omitempty"`
	// mute_offset_seconds is the mute offset into the vod
	MuteOffsetSeconds *google_protobuf.Int64Value `protobuf:"bytes,15,opt,name=mute_offset_seconds,json=muteOffsetSeconds" json:"mute_offset_seconds,omitempty"`
	// mute_duration_seconds is the mute duration
	MuteDurationSeconds *google_protobuf.Int64Value `protobuf:"bytes,16,opt,name=mute_duration_seconds,json=muteDurationSeconds" json:"mute_duration_seconds,omitempty"`
	// audible_magic_item_id is the audible magic item id
	AudibleMagicItemId string `protobuf:"bytes,17,opt,name=audible_magic_item_id,json=audibleMagicItemId" json:"audible_magic_item_id,omitempty"`
	// created_at is when this amr was created
	CreatedAt *google_protobuf1.Timestamp `protobuf:"bytes,18,opt,name=created_at,json=createdAt" json:"created_at,omitempty"`
	// updated_at is when this amr was updated
	UpdatedAt *google_protobuf1.Timestamp `protobuf:"bytes,19,opt,name=updated_at,json=updatedAt" json:"updated_at,omitempty"`
	// song_length is how long the song is
	SongLength int64 `protobuf:"varint,20,opt,name=song_length,json=songLength" json:"song_length,omitempty"`
	// unmuted_at is when this amr was unmuted
	UnmutedAt *google_protobuf1.Timestamp `protobuf:"bytes,21,opt,name=unmuted_at,json=unmutedAt" json:"unmuted_at,omitempty"`
}

func (m *AudibleMagicResponse) Reset()                    { *m = AudibleMagicResponse{} }
func (m *AudibleMagicResponse) String() string            { return proto.CompactTextString(m) }
func (*AudibleMagicResponse) ProtoMessage()               {}
func (*AudibleMagicResponse) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{3} }

func (m *AudibleMagicResponse) GetAudibleMagicResponseId() string {
	if m != nil {
		return m.AudibleMagicResponseId
	}
	return ""
}

func (m *AudibleMagicResponse) GetVodId() string {
	if m != nil {
		return m.VodId
	}
	return ""
}

func (m *AudibleMagicResponse) GetTitle() string {
	if m != nil {
		return m.Title
	}
	return ""
}

func (m *AudibleMagicResponse) GetPerformer() string {
	if m != nil {
		return m.Performer
	}
	return ""
}

func (m *AudibleMagicResponse) GetGenre() string {
	if m != nil {
		return m.Genre
	}
	return ""
}

func (m *AudibleMagicResponse) GetArtist() string {
	if m != nil {
		return m.Artist
	}
	return ""
}

func (m *AudibleMagicResponse) GetAlbumTitle() string {
	if m != nil {
		return m.AlbumTitle
	}
	return ""
}

func (m *AudibleMagicResponse) GetSong() string {
	if m != nil {
		return m.Song
	}
	return ""
}

func (m *AudibleMagicResponse) GetIsrc() string {
	if m != nil {
		return m.Isrc
	}
	return ""
}

func (m *AudibleMagicResponse) GetIsMatch() bool {
	if m != nil {
		return m.IsMatch
	}
	return false
}

func (m *AudibleMagicResponse) GetMatchOffsetSeconds() *google_protobuf.Int64Value {
	if m != nil {
		return m.MatchOffsetSeconds
	}
	return nil
}

func (m *AudibleMagicResponse) GetMatchDurationSeconds() *google_protobuf.Int64Value {
	if m != nil {
		return m.MatchDurationSeconds
	}
	return nil
}

func (m *AudibleMagicResponse) GetScanOffsetSeconds() *google_protobuf.Int64Value {
	if m != nil {
		return m.ScanOffsetSeconds
	}
	return nil
}

func (m *AudibleMagicResponse) GetScanDurationSeconds() *google_protobuf.Int64Value {
	if m != nil {
		return m.ScanDurationSeconds
	}
	return nil
}

func (m *AudibleMagicResponse) GetMuteOffsetSeconds() *google_protobuf.Int64Value {
	if m != nil {
		return m.MuteOffsetSeconds
	}
	return nil
}

func (m *AudibleMagicResponse) GetMuteDurationSeconds() *google_protobuf.Int64Value {
	if m != nil {
		return m.MuteDurationSeconds
	}
	return nil
}

func (m *AudibleMagicResponse) GetAudibleMagicItemId() string {
	if m != nil {
		return m.AudibleMagicItemId
	}
	return ""
}

func (m *AudibleMagicResponse) GetCreatedAt() *google_protobuf1.Timestamp {
	if m != nil {
		return m.CreatedAt
	}
	return nil
}

func (m *AudibleMagicResponse) GetUpdatedAt() *google_protobuf1.Timestamp {
	if m != nil {
		return m.UpdatedAt
	}
	return nil
}

func (m *AudibleMagicResponse) GetSongLength() int64 {
	if m != nil {
		return m.SongLength
	}
	return 0
}

func (m *AudibleMagicResponse) GetUnmutedAt() *google_protobuf1.Timestamp {
	if m != nil {
		return m.UnmutedAt
	}
	return nil
}

type VodMutedSegment struct {
	// offset is the offset into the vod for the muted segment
	Offset int64 `protobuf:"varint,1,opt,name=offset" json:"offset,omitempty"`
	// duration is the duration of the muted segment
	Duration int64 `protobuf:"varint,2,opt,name=duration" json:"duration,omitempty"`
}

func (m *VodMutedSegment) Reset()                    { *m = VodMutedSegment{} }
func (m *VodMutedSegment) String() string            { return proto.CompactTextString(m) }
func (*VodMutedSegment) ProtoMessage()               {}
func (*VodMutedSegment) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{4} }

func (m *VodMutedSegment) GetOffset() int64 {
	if m != nil {
		return m.Offset
	}
	return 0
}

func (m *VodMutedSegment) GetDuration() int64 {
	if m != nil {
		return m.Duration
	}
	return 0
}

type VodAppeal struct {
	// vod_appeal_id is the vod appeal id
	VodAppealId string `protobuf:"bytes,1,opt,name=vod_appeal_id,json=vodAppealId" json:"vod_appeal_id,omitempty"`
	// resolved_at is when this appeal was resolved
	ResolvedAt *google_protobuf1.Timestamp `protobuf:"bytes,2,opt,name=resolved_at,json=resolvedAt" json:"resolved_at,omitempty"`
	// created_at is when this appeal was created
	CreatedAt *google_protobuf1.Timestamp `protobuf:"bytes,3,opt,name=created_at,json=createdAt" json:"created_at,omitempty"`
	// updated_at is when this appeal was update
	UpdatedAt *google_protobuf1.Timestamp `protobuf:"bytes,4,opt,name=updated_at,json=updatedAt" json:"updated_at,omitempty"`
	// vod_id is the id of the vod that this appeal is for
	VodId string `protobuf:"bytes,5,opt,name=vod_id,json=vodId" json:"vod_id,omitempty"`
	// priority is whether this appeal is a priority
	Priority bool `protobuf:"varint,6,opt,name=priority" json:"priority,omitempty"`
	// full_name is the appeal full name
	FullName string `protobuf:"bytes,7,opt,name=full_name,json=fullName" json:"full_name,omitempty"`
	// street_address1 is the appeal street address 1
	StreetAddress1 string `protobuf:"bytes,8,opt,name=street_address1,json=streetAddress1" json:"street_address1,omitempty"`
	// street_address2 is the appeal street address 2
	StreetAddress2 string `protobuf:"bytes,9,opt,name=street_address2,json=streetAddress2" json:"street_address2,omitempty"`
	// city is the appeal city
	City string `protobuf:"bytes,10,opt,name=city" json:"city,omitempty"`
	// state is the appeal state
	State string `protobuf:"bytes,11,opt,name=state" json:"state,omitempty"`
	// zipcode is the appeal zipcode
	Zipcode string `protobuf:"bytes,12,opt,name=zipcode" json:"zipcode,omitempty"`
	// country is the appeal country
	Country string `protobuf:"bytes,13,opt,name=country" json:"country,omitempty"`
}

func (m *VodAppeal) Reset()                    { *m = VodAppeal{} }
func (m *VodAppeal) String() string            { return proto.CompactTextString(m) }
func (*VodAppeal) ProtoMessage()               {}
func (*VodAppeal) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{5} }

func (m *VodAppeal) GetVodAppealId() string {
	if m != nil {
		return m.VodAppealId
	}
	return ""
}

func (m *VodAppeal) GetResolvedAt() *google_protobuf1.Timestamp {
	if m != nil {
		return m.ResolvedAt
	}
	return nil
}

func (m *VodAppeal) GetCreatedAt() *google_protobuf1.Timestamp {
	if m != nil {
		return m.CreatedAt
	}
	return nil
}

func (m *VodAppeal) GetUpdatedAt() *google_protobuf1.Timestamp {
	if m != nil {
		return m.UpdatedAt
	}
	return nil
}

func (m *VodAppeal) GetVodId() string {
	if m != nil {
		return m.VodId
	}
	return ""
}

func (m *VodAppeal) GetPriority() bool {
	if m != nil {
		return m.Priority
	}
	return false
}

func (m *VodAppeal) GetFullName() string {
	if m != nil {
		return m.FullName
	}
	return ""
}

func (m *VodAppeal) GetStreetAddress1() string {
	if m != nil {
		return m.StreetAddress1
	}
	return ""
}

func (m *VodAppeal) GetStreetAddress2() string {
	if m != nil {
		return m.StreetAddress2
	}
	return ""
}

func (m *VodAppeal) GetCity() string {
	if m != nil {
		return m.City
	}
	return ""
}

func (m *VodAppeal) GetState() string {
	if m != nil {
		return m.State
	}
	return ""
}

func (m *VodAppeal) GetZipcode() string {
	if m != nil {
		return m.Zipcode
	}
	return ""
}

func (m *VodAppeal) GetCountry() string {
	if m != nil {
		return m.Country
	}
	return ""
}

type TrackAppeal struct {
	// track_appeal_id is the track appeal id
	TrackAppealId string `protobuf:"bytes,1,opt,name=track_appeal_id,json=trackAppealId" json:"track_appeal_id,omitempty"`
	// audible_magic_response_id is the audible magic response id
	AudibleMagicResponseId string `protobuf:"bytes,2,opt,name=audible_magic_response_id,json=audibleMagicResponseId" json:"audible_magic_response_id,omitempty"`
	// vod_appeal_id is the vod appeal id
	VodAppealId string `protobuf:"bytes,3,opt,name=vod_appeal_id,json=vodAppealId" json:"vod_appeal_id,omitempty"`
	// reason is the reason for the appeal
	Reason string `protobuf:"bytes,4,opt,name=reason" json:"reason,omitempty"`
	// created_at is when this appeal was created
	CreatedAt *google_protobuf1.Timestamp `protobuf:"bytes,5,opt,name=created_at,json=createdAt" json:"created_at,omitempty"`
	// updated_at is when this appeal was update
	UpdatedAt *google_protobuf1.Timestamp `protobuf:"bytes,6,opt,name=updated_at,json=updatedAt" json:"updated_at,omitempty"`
	// resolved_at is when this appeal was resolved
	ResolvedAt *google_protobuf1.Timestamp `protobuf:"bytes,7,opt,name=resolved_at,json=resolvedAt" json:"resolved_at,omitempty"`
}

func (m *TrackAppeal) Reset()                    { *m = TrackAppeal{} }
func (m *TrackAppeal) String() string            { return proto.CompactTextString(m) }
func (*TrackAppeal) ProtoMessage()               {}
func (*TrackAppeal) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{6} }

func (m *TrackAppeal) GetTrackAppealId() string {
	if m != nil {
		return m.TrackAppealId
	}
	return ""
}

func (m *TrackAppeal) GetAudibleMagicResponseId() string {
	if m != nil {
		return m.AudibleMagicResponseId
	}
	return ""
}

func (m *TrackAppeal) GetVodAppealId() string {
	if m != nil {
		return m.VodAppealId
	}
	return ""
}

func (m *TrackAppeal) GetReason() string {
	if m != nil {
		return m.Reason
	}
	return ""
}

func (m *TrackAppeal) GetCreatedAt() *google_protobuf1.Timestamp {
	if m != nil {
		return m.CreatedAt
	}
	return nil
}

func (m *TrackAppeal) GetUpdatedAt() *google_protobuf1.Timestamp {
	if m != nil {
		return m.UpdatedAt
	}
	return nil
}

func (m *TrackAppeal) GetResolvedAt() *google_protobuf1.Timestamp {
	if m != nil {
		return m.ResolvedAt
	}
	return nil
}

type VodNotificationSetting struct {
	// id is the id of the notification setting
	Id string `protobuf:"bytes,1,opt,name=id" json:"id,omitempty"`
	// vod_id is the id of the vod that this notification setting is for
	VodId string `protobuf:"bytes,2,opt,name=vod_id,json=vodId" json:"vod_id,omitempty"`
	// type is the notification setting type
	Type VodNotificationSettingType `protobuf:"varint,3,opt,name=type,enum=vodapi.VodNotificationSettingType" json:"type,omitempty"`
	// custom_text is the custom text for this notification setting
	CustomText *google_protobuf.StringValue `protobuf:"bytes,4,opt,name=custom_text,json=customText" json:"custom_text,omitempty"`
	// enabled is whether this notification setting is enabled
	Enabled bool `protobuf:"varint,5,opt,name=enabled" json:"enabled,omitempty"`
	// sent_at is when the notification was sent
	SentAt *google_protobuf1.Timestamp `protobuf:"bytes,6,opt,name=sent_at,json=sentAt" json:"sent_at,omitempty"`
	// created_at is when this notification setting was created
	CreatedAt *google_protobuf1.Timestamp `protobuf:"bytes,7,opt,name=created_at,json=createdAt" json:"created_at,omitempty"`
	// updated_at is when this notification settting was updated
	UpdatedAt *google_protobuf1.Timestamp `protobuf:"bytes,8,opt,name=updated_at,json=updatedAt" json:"updated_at,omitempty"`
}

func (m *VodNotificationSetting) Reset()                    { *m = VodNotificationSetting{} }
func (m *VodNotificationSetting) String() string            { return proto.CompactTextString(m) }
func (*VodNotificationSetting) ProtoMessage()               {}
func (*VodNotificationSetting) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{7} }

func (m *VodNotificationSetting) GetId() string {
	if m != nil {
		return m.Id
	}
	return ""
}

func (m *VodNotificationSetting) GetVodId() string {
	if m != nil {
		return m.VodId
	}
	return ""
}

func (m *VodNotificationSetting) GetType() VodNotificationSettingType {
	if m != nil {
		return m.Type
	}
	return VodNotificationSettingType_INVALID_NOTIFICATION_SETTING_TYPE
}

func (m *VodNotificationSetting) GetCustomText() *google_protobuf.StringValue {
	if m != nil {
		return m.CustomText
	}
	return nil
}

func (m *VodNotificationSetting) GetEnabled() bool {
	if m != nil {
		return m.Enabled
	}
	return false
}

func (m *VodNotificationSetting) GetSentAt() *google_protobuf1.Timestamp {
	if m != nil {
		return m.SentAt
	}
	return nil
}

func (m *VodNotificationSetting) GetCreatedAt() *google_protobuf1.Timestamp {
	if m != nil {
		return m.CreatedAt
	}
	return nil
}

func (m *VodNotificationSetting) GetUpdatedAt() *google_protobuf1.Timestamp {
	if m != nil {
		return m.UpdatedAt
	}
	return nil
}

type VodNotificationSettingsMap struct {
	// email is the notification settings for email
	Email *VodNotificationSetting `protobuf:"bytes,1,opt,name=email" json:"email,omitempty"`
	// email is the notification settings for channel feed
	ChannelFeed *VodNotificationSetting `protobuf:"bytes,2,opt,name=channel_feed,json=channelFeed" json:"channel_feed,omitempty"`
}

func (m *VodNotificationSettingsMap) Reset()                    { *m = VodNotificationSettingsMap{} }
func (m *VodNotificationSettingsMap) String() string            { return proto.CompactTextString(m) }
func (*VodNotificationSettingsMap) ProtoMessage()               {}
func (*VodNotificationSettingsMap) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{8} }

func (m *VodNotificationSettingsMap) GetEmail() *VodNotificationSetting {
	if m != nil {
		return m.Email
	}
	return nil
}

func (m *VodNotificationSettingsMap) GetChannelFeed() *VodNotificationSetting {
	if m != nil {
		return m.ChannelFeed
	}
	return nil
}

type Vod struct {
	// broadcast_id is the broadcast id for the vod
	BroadcastId string `protobuf:"bytes,1,opt,name=broadcast_id,json=broadcastId" json:"broadcast_id,omitempty"`
	// broadcast_type is the broadcast type for the vod
	BroadcastType VodType `protobuf:"varint,2,opt,name=broadcast_type,json=broadcastType,enum=vodapi.VodType" json:"broadcast_type,omitempty"`
	// broadcaster_software is the software used to broadcast
	BroadcasterSoftware *google_protobuf.StringValue `protobuf:"bytes,3,opt,name=broadcaster_software,json=broadcasterSoftware" json:"broadcaster_software,omitempty"`
	// communities is the set of communities that is related to this vod
	Communities []string `protobuf:"bytes,4,rep,name=communities" json:"communities,omitempty"`
	// created_at is when the vod was created
	CreatedAt *google_protobuf1.Timestamp `protobuf:"bytes,5,opt,name=created_at,json=createdAt" json:"created_at,omitempty"`
	// created_by is who created the vod, could be an editor
	CreatedBy *google_protobuf.StringValue `protobuf:"bytes,6,opt,name=created_by,json=createdBy" json:"created_by,omitempty"`
	// delete_at is when the vod is deleted
	DeleteAt *google_protobuf1.Timestamp `protobuf:"bytes,7,opt,name=delete_at,json=deleteAt" json:"delete_at,omitempty"`
	// deleted is whether the vod is deleted, might eventually be consolidated with status
	Deleted *google_protobuf.BoolValue `protobuf:"bytes,8,opt,name=deleted" json:"deleted,omitempty"`
	// description is the description for the vod
	Description *google_protobuf.StringValue `protobuf:"bytes,9,opt,name=description" json:"description,omitempty"`
	// description_html is the html version of the description
	DescriptionHtml *google_protobuf.StringValue `protobuf:"bytes,10,opt,name=description_html,json=descriptionHtml" json:"description_html,omitempty"`
	// duration is the duration of the vod
	Duration int64 `protobuf:"varint,11,opt,name=duration" json:"duration,omitempty"`
	// fps is the frames per second formats for a vod, should be consolidated with other format stuff, resolutions and show_formats
	Fps map[string]float64 `protobuf:"bytes,13,rep,name=fps" json:"fps,omitempty" protobuf_key:"bytes,1,opt,name=key" protobuf_val:"fixed64,2,opt,name=value"`
	// game is the game for the vod
	Game *google_protobuf.StringValue `protobuf:"bytes,14,opt,name=game" json:"game,omitempty"`
	// id is the identifier for the vod
	Id string `protobuf:"bytes,15,opt,name=id" json:"id,omitempty"`
	// language is the language of the vod
	Language *google_protobuf.StringValue `protobuf:"bytes,16,opt,name=language" json:"language,omitempty"`
	// manifest is the path to the manifest file
	Manifest *google_protobuf.StringValue `protobuf:"bytes,17,opt,name=manifest" json:"manifest,omitempty"`
	// offset is the offset into the source vod, used for highlights and should be deprecated
	Offset int64 `protobuf:"varint,18,opt,name=offset" json:"offset,omitempty"`
	// origin is the where this vod originated from
	Origin *google_protobuf.StringValue `protobuf:"bytes,19,opt,name=origin" json:"origin,omitempty"`
	// owner_id is the owner of the vod
	OwnerId string `protobuf:"bytes,20,opt,name=owner_id,json=ownerId" json:"owner_id,omitempty"`
	// resolutions is the resolutions formats for a vod, should be consolidated with other format stuff, fps and show_formats
	Resolutions map[string]string `protobuf:"bytes,21,rep,name=resolutions" json:"resolutions,omitempty" protobuf_key:"bytes,1,opt,name=key" protobuf_val:"bytes,2,opt,name=value"`
	// source_archive_id is the id of the source vod, used for highlights and should be deprecated
	SourceArchiveId *google_protobuf.StringValue `protobuf:"bytes,22,opt,name=source_archive_id,json=sourceArchiveId" json:"source_archive_id,omitempty"`
	// started_on is when the vod was started
	StartedOn *google_protobuf1.Timestamp `protobuf:"bytes,23,opt,name=started_on,json=startedOn" json:"started_on,omitempty"`
	// status is the status of the vod
	Status VodStatus `protobuf:"varint,24,opt,name=status,enum=vodapi.VodStatus" json:"status,omitempty"`
	// tag_list is the list of tags for a vod
	TagList []string `protobuf:"bytes,25,rep,name=tag_list,json=tagList" json:"tag_list,omitempty"`
	// title is the title for the vod
	Title *google_protobuf.StringValue `protobuf:"bytes,26,opt,name=title" json:"title,omitempty"`
	// total_length is the total length of the vod
	TotalLength int64 `protobuf:"varint,27,opt,name=total_length,json=totalLength" json:"total_length,omitempty"`
	// updated_at is when the vod was updated
	UpdatedAt *google_protobuf1.Timestamp `protobuf:"bytes,28,opt,name=updated_at,json=updatedAt" json:"updated_at,omitempty"`
	// uri is the uri path to the vod ts chunks
	Uri string `protobuf:"bytes,29,opt,name=uri" json:"uri,omitempty"`
	// viewable is whether the vod is viewable
	Viewable VodViewable `protobuf:"varint,30,opt,name=viewable,enum=vodapi.VodViewable" json:"viewable,omitempty"`
	// viewable_at is when the vod became viewable
	ViewableAt *google_protobuf1.Timestamp `protobuf:"bytes,31,opt,name=viewable_at,json=viewableAt" json:"viewable_at,omitempty"`
	// views is the number of views for the vod
	Views int64 `protobuf:"varint,32,opt,name=views" json:"views,omitempty"`
	// published_at is when the vod was published
	PublishedAt *google_protobuf1.Timestamp `protobuf:"bytes,33,opt,name=published_at,json=publishedAt" json:"published_at,omitempty"`
	// increment_view_url is the url to increment the view count
	IncrementViewUrl string `protobuf:"bytes,34,opt,name=increment_view_url,json=incrementViewUrl" json:"increment_view_url,omitempty"`
	// qualities is the qualities format for a vod, should be consolidated with other format stuff, fps and show_formats
	Qualities []string `protobuf:"bytes,35,rep,name=qualities" json:"qualities,omitempty"`
	// preview_template is the thumbnail template for preview
	PreviewTemplate string `protobuf:"bytes,36,opt,name=preview_template,json=previewTemplate" json:"preview_template,omitempty"`
	// show_formats is the show_formats format for a vod, should be consolidated with other format stuff, fps and resolutions
	ShowFormats map[string]*ShowFormat `protobuf:"bytes,37,rep,name=show_formats,json=showFormats" json:"show_formats,omitempty" protobuf_key:"bytes,1,opt,name=key" protobuf_val:"bytes,2,opt,name=value"`
	// thumbnail_templates is the list of thumbnail templates
	ThumbnailTemplates []*ThumbnailTemplate `protobuf:"bytes,38,rep,name=thumbnail_templates,json=thumbnailTemplates" json:"thumbnail_templates,omitempty"`
	// seek_previews_url is the url for seek previews
	SeekPreviewsUrl string `protobuf:"bytes,40,opt,name=seek_previews_url,json=seekPreviewsUrl" json:"seek_previews_url,omitempty"`
	// animated_preview_url is the url for animated previews
	AnimatedPreviewUrl string `protobuf:"bytes,41,opt,name=animated_preview_url,json=animatedPreviewUrl" json:"animated_preview_url,omitempty"`
	// path is the path to the vod
	Path string `protobuf:"bytes,42,opt,name=path" json:"path,omitempty"`
	// url is the url to the vod
	Url string `protobuf:"bytes,43,opt,name=url" json:"url,omitempty"`
	// notifications_setting is the notifications settings for the vod
	NotificationsSetting *VodNotificationSettingsMap `protobuf:"bytes,44,opt,name=notifications_setting,json=notificationsSetting" json:"notifications_setting,omitempty"`
	// handwave_latency_ms is the handwave latency for the vod
	HandwaveLatencyMs *google_protobuf.Int64Value `protobuf:"bytes,45,opt,name=handwave_latency_ms,json=handwaveLatencyMs" json:"handwave_latency_ms,omitempty"`
	// failure is the create error response
	Failure *CreateErrorResponse `protobuf:"bytes,46,opt,name=failure" json:"failure,omitempty"`
}

func (m *Vod) Reset()                    { *m = Vod{} }
func (m *Vod) String() string            { return proto.CompactTextString(m) }
func (*Vod) ProtoMessage()               {}
func (*Vod) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{9} }

func (m *Vod) GetBroadcastId() string {
	if m != nil {
		return m.BroadcastId
	}
	return ""
}

func (m *Vod) GetBroadcastType() VodType {
	if m != nil {
		return m.BroadcastType
	}
	return VodType_INVALID_TYPE
}

func (m *Vod) GetBroadcasterSoftware() *google_protobuf.StringValue {
	if m != nil {
		return m.BroadcasterSoftware
	}
	return nil
}

func (m *Vod) GetCommunities() []string {
	if m != nil {
		return m.Communities
	}
	return nil
}

func (m *Vod) GetCreatedAt() *google_protobuf1.Timestamp {
	if m != nil {
		return m.CreatedAt
	}
	return nil
}

func (m *Vod) GetCreatedBy() *google_protobuf.StringValue {
	if m != nil {
		return m.CreatedBy
	}
	return nil
}

func (m *Vod) GetDeleteAt() *google_protobuf1.Timestamp {
	if m != nil {
		return m.DeleteAt
	}
	return nil
}

func (m *Vod) GetDeleted() *google_protobuf.BoolValue {
	if m != nil {
		return m.Deleted
	}
	return nil
}

func (m *Vod) GetDescription() *google_protobuf.StringValue {
	if m != nil {
		return m.Description
	}
	return nil
}

func (m *Vod) GetDescriptionHtml() *google_protobuf.StringValue {
	if m != nil {
		return m.DescriptionHtml
	}
	return nil
}

func (m *Vod) GetDuration() int64 {
	if m != nil {
		return m.Duration
	}
	return 0
}

func (m *Vod) GetFps() map[string]float64 {
	if m != nil {
		return m.Fps
	}
	return nil
}

func (m *Vod) GetGame() *google_protobuf.StringValue {
	if m != nil {
		return m.Game
	}
	return nil
}

func (m *Vod) GetId() string {
	if m != nil {
		return m.Id
	}
	return ""
}

func (m *Vod) GetLanguage() *google_protobuf.StringValue {
	if m != nil {
		return m.Language
	}
	return nil
}

func (m *Vod) GetManifest() *google_protobuf.StringValue {
	if m != nil {
		return m.Manifest
	}
	return nil
}

func (m *Vod) GetOffset() int64 {
	if m != nil {
		return m.Offset
	}
	return 0
}

func (m *Vod) GetOrigin() *google_protobuf.StringValue {
	if m != nil {
		return m.Origin
	}
	return nil
}

func (m *Vod) GetOwnerId() string {
	if m != nil {
		return m.OwnerId
	}
	return ""
}

func (m *Vod) GetResolutions() map[string]string {
	if m != nil {
		return m.Resolutions
	}
	return nil
}

func (m *Vod) GetSourceArchiveId() *google_protobuf.StringValue {
	if m != nil {
		return m.SourceArchiveId
	}
	return nil
}

func (m *Vod) GetStartedOn() *google_protobuf1.Timestamp {
	if m != nil {
		return m.StartedOn
	}
	return nil
}

func (m *Vod) GetStatus() VodStatus {
	if m != nil {
		return m.Status
	}
	return VodStatus_INVALID_STATUS
}

func (m *Vod) GetTagList() []string {
	if m != nil {
		return m.TagList
	}
	return nil
}

func (m *Vod) GetTitle() *google_protobuf.StringValue {
	if m != nil {
		return m.Title
	}
	return nil
}

func (m *Vod) GetTotalLength() int64 {
	if m != nil {
		return m.TotalLength
	}
	return 0
}

func (m *Vod) GetUpdatedAt() *google_protobuf1.Timestamp {
	if m != nil {
		return m.UpdatedAt
	}
	return nil
}

func (m *Vod) GetUri() string {
	if m != nil {
		return m.Uri
	}
	return ""
}

func (m *Vod) GetViewable() VodViewable {
	if m != nil {
		return m.Viewable
	}
	return VodViewable_INVALID_VIEWABLE
}

func (m *Vod) GetViewableAt() *google_protobuf1.Timestamp {
	if m != nil {
		return m.ViewableAt
	}
	return nil
}

func (m *Vod) GetViews() int64 {
	if m != nil {
		return m.Views
	}
	return 0
}

func (m *Vod) GetPublishedAt() *google_protobuf1.Timestamp {
	if m != nil {
		return m.PublishedAt
	}
	return nil
}

func (m *Vod) GetIncrementViewUrl() string {
	if m != nil {
		return m.IncrementViewUrl
	}
	return ""
}

func (m *Vod) GetQualities() []string {
	if m != nil {
		return m.Qualities
	}
	return nil
}

func (m *Vod) GetPreviewTemplate() string {
	if m != nil {
		return m.PreviewTemplate
	}
	return ""
}

func (m *Vod) GetShowFormats() map[string]*ShowFormat {
	if m != nil {
		return m.ShowFormats
	}
	return nil
}

func (m *Vod) GetThumbnailTemplates() []*ThumbnailTemplate {
	if m != nil {
		return m.ThumbnailTemplates
	}
	return nil
}

func (m *Vod) GetSeekPreviewsUrl() string {
	if m != nil {
		return m.SeekPreviewsUrl
	}
	return ""
}

func (m *Vod) GetAnimatedPreviewUrl() string {
	if m != nil {
		return m.AnimatedPreviewUrl
	}
	return ""
}

func (m *Vod) GetPath() string {
	if m != nil {
		return m.Path
	}
	return ""
}

func (m *Vod) GetUrl() string {
	if m != nil {
		return m.Url
	}
	return ""
}

func (m *Vod) GetNotificationsSetting() *VodNotificationSettingsMap {
	if m != nil {
		return m.NotificationsSetting
	}
	return nil
}

func (m *Vod) GetHandwaveLatencyMs() *google_protobuf.Int64Value {
	if m != nil {
		return m.HandwaveLatencyMs
	}
	return nil
}

func (m *Vod) GetFailure() *CreateErrorResponse {
	if m != nil {
		return m.Failure
	}
	return nil
}

type CreateUploadResponse struct {
	// vod is the vod response
	Vod *Vod `protobuf:"bytes,1,opt,name=vod" json:"vod,omitempty"`
}

func (m *CreateUploadResponse) Reset()                    { *m = CreateUploadResponse{} }
func (m *CreateUploadResponse) String() string            { return proto.CompactTextString(m) }
func (*CreateUploadResponse) ProtoMessage()               {}
func (*CreateUploadResponse) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{10} }

func (m *CreateUploadResponse) GetVod() *Vod {
	if m != nil {
		return m.Vod
	}
	return nil
}

type CreateArchiveResponse struct {
	// vod is the vod response
	Vod *Vod `protobuf:"bytes,1,opt,name=vod" json:"vod,omitempty"`
}

func (m *CreateArchiveResponse) Reset()                    { *m = CreateArchiveResponse{} }
func (m *CreateArchiveResponse) String() string            { return proto.CompactTextString(m) }
func (*CreateArchiveResponse) ProtoMessage()               {}
func (*CreateArchiveResponse) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{11} }

func (m *CreateArchiveResponse) GetVod() *Vod {
	if m != nil {
		return m.Vod
	}
	return nil
}

type InternalCreateHighlightResponse struct {
	// vod is the vod response
	Vod *Vod `protobuf:"bytes,1,opt,name=vod" json:"vod,omitempty"`
}

func (m *InternalCreateHighlightResponse) Reset()         { *m = InternalCreateHighlightResponse{} }
func (m *InternalCreateHighlightResponse) String() string { return proto.CompactTextString(m) }
func (*InternalCreateHighlightResponse) ProtoMessage()    {}
func (*InternalCreateHighlightResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor0, []int{12}
}

func (m *InternalCreateHighlightResponse) GetVod() *Vod {
	if m != nil {
		return m.Vod
	}
	return nil
}

type ManagerCreateHighlightResponse struct {
	// vod is the vod response
	Vod *Vod `protobuf:"bytes,1,opt,name=vod" json:"vod,omitempty"`
}

func (m *ManagerCreateHighlightResponse) Reset()                    { *m = ManagerCreateHighlightResponse{} }
func (m *ManagerCreateHighlightResponse) String() string            { return proto.CompactTextString(m) }
func (*ManagerCreateHighlightResponse) ProtoMessage()               {}
func (*ManagerCreateHighlightResponse) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{13} }

func (m *ManagerCreateHighlightResponse) GetVod() *Vod {
	if m != nil {
		return m.Vod
	}
	return nil
}

type PublicGetVodByIDResponse struct {
	// vod is the vod response
	Vod *Vod `protobuf:"bytes,1,opt,name=vod" json:"vod,omitempty"`
}

func (m *PublicGetVodByIDResponse) Reset()                    { *m = PublicGetVodByIDResponse{} }
func (m *PublicGetVodByIDResponse) String() string            { return proto.CompactTextString(m) }
func (*PublicGetVodByIDResponse) ProtoMessage()               {}
func (*PublicGetVodByIDResponse) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{14} }

func (m *PublicGetVodByIDResponse) GetVod() *Vod {
	if m != nil {
		return m.Vod
	}
	return nil
}

type InternalGetVodByIDResponse struct {
	// vod is the vod response
	Vod *Vod `protobuf:"bytes,1,opt,name=vod" json:"vod,omitempty"`
}

func (m *InternalGetVodByIDResponse) Reset()                    { *m = InternalGetVodByIDResponse{} }
func (m *InternalGetVodByIDResponse) String() string            { return proto.CompactTextString(m) }
func (*InternalGetVodByIDResponse) ProtoMessage()               {}
func (*InternalGetVodByIDResponse) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{15} }

func (m *InternalGetVodByIDResponse) GetVod() *Vod {
	if m != nil {
		return m.Vod
	}
	return nil
}

type ManagerInternalGetVodByIDResponse struct {
	// vod is the vod response
	Vod *Vod `protobuf:"bytes,1,opt,name=vod" json:"vod,omitempty"`
}

func (m *ManagerInternalGetVodByIDResponse) Reset()         { *m = ManagerInternalGetVodByIDResponse{} }
func (m *ManagerInternalGetVodByIDResponse) String() string { return proto.CompactTextString(m) }
func (*ManagerInternalGetVodByIDResponse) ProtoMessage()    {}
func (*ManagerInternalGetVodByIDResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor0, []int{16}
}

func (m *ManagerInternalGetVodByIDResponse) GetVod() *Vod {
	if m != nil {
		return m.Vod
	}
	return nil
}

type VodMuteInfoResponse struct {
	// id is the vod id
	Id string `protobuf:"bytes,1,opt,name=id" json:"id,omitempty"`
	// audible_magic_responses is the list of audible magic responses
	AudibleMagicResponses []*AudibleMagicResponse `protobuf:"bytes,2,rep,name=audible_magic_responses,json=audibleMagicResponses" json:"audible_magic_responses,omitempty"`
	// muted_segments is the list of muted segments
	MutedSegments []*VodMutedSegment `protobuf:"bytes,3,rep,name=muted_segments,json=mutedSegments" json:"muted_segments,omitempty"`
	// vod_appeal is the vod appeal
	VodAppeal *VodAppeal `protobuf:"bytes,4,opt,name=vod_appeal,json=vodAppeal" json:"vod_appeal,omitempty"`
	// track_appeals is the list of track appeals
	TrackAppeals []*TrackAppeal `protobuf:"bytes,5,rep,name=track_appeals,json=trackAppeals" json:"track_appeals,omitempty"`
	// is_muted is whether the vod is muted
	IsMuted *google_protobuf.BoolValue `protobuf:"bytes,6,opt,name=is_muted,json=isMuted" json:"is_muted,omitempty"`
	// can_create_appeal is whether the vod can be appealed
	CanCreateAppeal *google_protobuf.BoolValue `protobuf:"bytes,7,opt,name=can_create_appeal,json=canCreateAppeal" json:"can_create_appeal,omitempty"`
	// can_create_appeal is wehther the appeal is view only
	ViewOnlyAppeal *google_protobuf.BoolValue `protobuf:"bytes,8,opt,name=view_only_appeal,json=viewOnlyAppeal" json:"view_only_appeal,omitempty"`
	// has_pending_appeal is wehther an appeal is already created
	HasPendingAppeal *google_protobuf.BoolValue `protobuf:"bytes,9,opt,name=has_pending_appeal,json=hasPendingAppeal" json:"has_pending_appeal,omitempty"`
}

func (m *VodMuteInfoResponse) Reset()                    { *m = VodMuteInfoResponse{} }
func (m *VodMuteInfoResponse) String() string            { return proto.CompactTextString(m) }
func (*VodMuteInfoResponse) ProtoMessage()               {}
func (*VodMuteInfoResponse) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{17} }

func (m *VodMuteInfoResponse) GetId() string {
	if m != nil {
		return m.Id
	}
	return ""
}

func (m *VodMuteInfoResponse) GetAudibleMagicResponses() []*AudibleMagicResponse {
	if m != nil {
		return m.AudibleMagicResponses
	}
	return nil
}

func (m *VodMuteInfoResponse) GetMutedSegments() []*VodMutedSegment {
	if m != nil {
		return m.MutedSegments
	}
	return nil
}

func (m *VodMuteInfoResponse) GetVodAppeal() *VodAppeal {
	if m != nil {
		return m.VodAppeal
	}
	return nil
}

func (m *VodMuteInfoResponse) GetTrackAppeals() []*TrackAppeal {
	if m != nil {
		return m.TrackAppeals
	}
	return nil
}

func (m *VodMuteInfoResponse) GetIsMuted() *google_protobuf.BoolValue {
	if m != nil {
		return m.IsMuted
	}
	return nil
}

func (m *VodMuteInfoResponse) GetCanCreateAppeal() *google_protobuf.BoolValue {
	if m != nil {
		return m.CanCreateAppeal
	}
	return nil
}

func (m *VodMuteInfoResponse) GetViewOnlyAppeal() *google_protobuf.BoolValue {
	if m != nil {
		return m.ViewOnlyAppeal
	}
	return nil
}

func (m *VodMuteInfoResponse) GetHasPendingAppeal() *google_protobuf.BoolValue {
	if m != nil {
		return m.HasPendingAppeal
	}
	return nil
}

type ManagerGetVodMuteInfoResponse struct {
	// mute_info is the mute info
	MuteInfo *VodMuteInfoResponse `protobuf:"bytes,1,opt,name=mute_info,json=muteInfo" json:"mute_info,omitempty"`
}

func (m *ManagerGetVodMuteInfoResponse) Reset()                    { *m = ManagerGetVodMuteInfoResponse{} }
func (m *ManagerGetVodMuteInfoResponse) String() string            { return proto.CompactTextString(m) }
func (*ManagerGetVodMuteInfoResponse) ProtoMessage()               {}
func (*ManagerGetVodMuteInfoResponse) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{18} }

func (m *ManagerGetVodMuteInfoResponse) GetMuteInfo() *VodMuteInfoResponse {
	if m != nil {
		return m.MuteInfo
	}
	return nil
}

type InternalGetVodMuteInfoResponse struct {
	// mute_info is the mute info
	MuteInfo *VodMuteInfoResponse `protobuf:"bytes,1,opt,name=mute_info,json=muteInfo" json:"mute_info,omitempty"`
}

func (m *InternalGetVodMuteInfoResponse) Reset()                    { *m = InternalGetVodMuteInfoResponse{} }
func (m *InternalGetVodMuteInfoResponse) String() string            { return proto.CompactTextString(m) }
func (*InternalGetVodMuteInfoResponse) ProtoMessage()               {}
func (*InternalGetVodMuteInfoResponse) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{19} }

func (m *InternalGetVodMuteInfoResponse) GetMuteInfo() *VodMuteInfoResponse {
	if m != nil {
		return m.MuteInfo
	}
	return nil
}

type ManagerGetVodMuteInfosResponse struct {
	// mute_infos is the mute infos
	MuteInfos []*VodMuteInfoResponse `protobuf:"bytes,1,rep,name=mute_infos,json=muteInfos" json:"mute_infos,omitempty"`
}

func (m *ManagerGetVodMuteInfosResponse) Reset()                    { *m = ManagerGetVodMuteInfosResponse{} }
func (m *ManagerGetVodMuteInfosResponse) String() string            { return proto.CompactTextString(m) }
func (*ManagerGetVodMuteInfosResponse) ProtoMessage()               {}
func (*ManagerGetVodMuteInfosResponse) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{20} }

func (m *ManagerGetVodMuteInfosResponse) GetMuteInfos() []*VodMuteInfoResponse {
	if m != nil {
		return m.MuteInfos
	}
	return nil
}

type GetVodByIDIncludeBannedUsersResponse struct {
	// vod is the vod response
	Vod *Vod `protobuf:"bytes,1,opt,name=vod" json:"vod,omitempty"`
}

func (m *GetVodByIDIncludeBannedUsersResponse) Reset()         { *m = GetVodByIDIncludeBannedUsersResponse{} }
func (m *GetVodByIDIncludeBannedUsersResponse) String() string { return proto.CompactTextString(m) }
func (*GetVodByIDIncludeBannedUsersResponse) ProtoMessage()    {}
func (*GetVodByIDIncludeBannedUsersResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor0, []int{21}
}

func (m *GetVodByIDIncludeBannedUsersResponse) GetVod() *Vod {
	if m != nil {
		return m.Vod
	}
	return nil
}

type ManagerGetVodByIDResponse struct {
	// vod is the vod response
	Vod *Vod `protobuf:"bytes,1,opt,name=vod" json:"vod,omitempty"`
}

func (m *ManagerGetVodByIDResponse) Reset()                    { *m = ManagerGetVodByIDResponse{} }
func (m *ManagerGetVodByIDResponse) String() string            { return proto.CompactTextString(m) }
func (*ManagerGetVodByIDResponse) ProtoMessage()               {}
func (*ManagerGetVodByIDResponse) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{22} }

func (m *ManagerGetVodByIDResponse) GetVod() *Vod {
	if m != nil {
		return m.Vod
	}
	return nil
}

type ManagerSearchVodsResponse struct {
	// vods is the vods response
	Vods []*Vod `protobuf:"bytes,1,rep,name=vods" json:"vods,omitempty"`
}

func (m *ManagerSearchVodsResponse) Reset()                    { *m = ManagerSearchVodsResponse{} }
func (m *ManagerSearchVodsResponse) String() string            { return proto.CompactTextString(m) }
func (*ManagerSearchVodsResponse) ProtoMessage()               {}
func (*ManagerSearchVodsResponse) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{23} }

func (m *ManagerSearchVodsResponse) GetVods() []*Vod {
	if m != nil {
		return m.Vods
	}
	return nil
}

type PublicGetVodsByUserResponse struct {
	// vods is the vods response
	Vods []*Vod `protobuf:"bytes,1,rep,name=vods" json:"vods,omitempty"`
}

func (m *PublicGetVodsByUserResponse) Reset()                    { *m = PublicGetVodsByUserResponse{} }
func (m *PublicGetVodsByUserResponse) String() string            { return proto.CompactTextString(m) }
func (*PublicGetVodsByUserResponse) ProtoMessage()               {}
func (*PublicGetVodsByUserResponse) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{24} }

func (m *PublicGetVodsByUserResponse) GetVods() []*Vod {
	if m != nil {
		return m.Vods
	}
	return nil
}

type ManagerInternalGetVodsByUserResponse struct {
	// vods is the vods response
	Vods []*Vod `protobuf:"bytes,1,rep,name=vods" json:"vods,omitempty"`
}

func (m *ManagerInternalGetVodsByUserResponse) Reset()         { *m = ManagerInternalGetVodsByUserResponse{} }
func (m *ManagerInternalGetVodsByUserResponse) String() string { return proto.CompactTextString(m) }
func (*ManagerInternalGetVodsByUserResponse) ProtoMessage()    {}
func (*ManagerInternalGetVodsByUserResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor0, []int{25}
}

func (m *ManagerInternalGetVodsByUserResponse) GetVods() []*Vod {
	if m != nil {
		return m.Vods
	}
	return nil
}

type ManagerGetVodsByUserIncludeBannedUsersResponse struct {
	// vods is the vods response
	Vods []*Vod `protobuf:"bytes,1,rep,name=vods" json:"vods,omitempty"`
}

func (m *ManagerGetVodsByUserIncludeBannedUsersResponse) Reset() {
	*m = ManagerGetVodsByUserIncludeBannedUsersResponse{}
}
func (m *ManagerGetVodsByUserIncludeBannedUsersResponse) String() string {
	return proto.CompactTextString(m)
}
func (*ManagerGetVodsByUserIncludeBannedUsersResponse) ProtoMessage() {}
func (*ManagerGetVodsByUserIncludeBannedUsersResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor0, []int{26}
}

func (m *ManagerGetVodsByUserIncludeBannedUsersResponse) GetVods() []*Vod {
	if m != nil {
		return m.Vods
	}
	return nil
}

type InternalGetVodsByBroadcastIDsResponse struct {
	// vods is the vods response
	Vods []*Vod `protobuf:"bytes,1,rep,name=vods" json:"vods,omitempty"`
}

func (m *InternalGetVodsByBroadcastIDsResponse) Reset()         { *m = InternalGetVodsByBroadcastIDsResponse{} }
func (m *InternalGetVodsByBroadcastIDsResponse) String() string { return proto.CompactTextString(m) }
func (*InternalGetVodsByBroadcastIDsResponse) ProtoMessage()    {}
func (*InternalGetVodsByBroadcastIDsResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor0, []int{27}
}

func (m *InternalGetVodsByBroadcastIDsResponse) GetVods() []*Vod {
	if m != nil {
		return m.Vods
	}
	return nil
}

type PublicGetVodsByIDsResponse struct {
	// vods is the vods response
	Vods []*Vod `protobuf:"bytes,1,rep,name=vods" json:"vods,omitempty"`
}

func (m *PublicGetVodsByIDsResponse) Reset()                    { *m = PublicGetVodsByIDsResponse{} }
func (m *PublicGetVodsByIDsResponse) String() string            { return proto.CompactTextString(m) }
func (*PublicGetVodsByIDsResponse) ProtoMessage()               {}
func (*PublicGetVodsByIDsResponse) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{28} }

func (m *PublicGetVodsByIDsResponse) GetVods() []*Vod {
	if m != nil {
		return m.Vods
	}
	return nil
}

type InternalGetVodsByIDsResponse struct {
	// vods is the vods response
	Vods []*Vod `protobuf:"bytes,1,rep,name=vods" json:"vods,omitempty"`
}

func (m *InternalGetVodsByIDsResponse) Reset()                    { *m = InternalGetVodsByIDsResponse{} }
func (m *InternalGetVodsByIDsResponse) String() string            { return proto.CompactTextString(m) }
func (*InternalGetVodsByIDsResponse) ProtoMessage()               {}
func (*InternalGetVodsByIDsResponse) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{29} }

func (m *InternalGetVodsByIDsResponse) GetVods() []*Vod {
	if m != nil {
		return m.Vods
	}
	return nil
}

type GetVodsByIDsIncludeBannedUsersResponse struct {
	// vods is the vods response
	Vods []*Vod `protobuf:"bytes,1,rep,name=vods" json:"vods,omitempty"`
}

func (m *GetVodsByIDsIncludeBannedUsersResponse) Reset() {
	*m = GetVodsByIDsIncludeBannedUsersResponse{}
}
func (m *GetVodsByIDsIncludeBannedUsersResponse) String() string { return proto.CompactTextString(m) }
func (*GetVodsByIDsIncludeBannedUsersResponse) ProtoMessage()    {}
func (*GetVodsByIDsIncludeBannedUsersResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor0, []int{30}
}

func (m *GetVodsByIDsIncludeBannedUsersResponse) GetVods() []*Vod {
	if m != nil {
		return m.Vods
	}
	return nil
}

type PublicGetVodsByUsersResponse struct {
	// vods is the vods response
	Vods []*Vod `protobuf:"bytes,1,rep,name=vods" json:"vods,omitempty"`
}

func (m *PublicGetVodsByUsersResponse) Reset()                    { *m = PublicGetVodsByUsersResponse{} }
func (m *PublicGetVodsByUsersResponse) String() string            { return proto.CompactTextString(m) }
func (*PublicGetVodsByUsersResponse) ProtoMessage()               {}
func (*PublicGetVodsByUsersResponse) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{31} }

func (m *PublicGetVodsByUsersResponse) GetVods() []*Vod {
	if m != nil {
		return m.Vods
	}
	return nil
}

type GetTopVodsResponse struct {
	// vods is the vods response
	Vods []*Vod `protobuf:"bytes,1,rep,name=vods" json:"vods,omitempty"`
}

func (m *GetTopVodsResponse) Reset()                    { *m = GetTopVodsResponse{} }
func (m *GetTopVodsResponse) String() string            { return proto.CompactTextString(m) }
func (*GetTopVodsResponse) ProtoMessage()               {}
func (*GetTopVodsResponse) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{32} }

func (m *GetTopVodsResponse) GetVods() []*Vod {
	if m != nil {
		return m.Vods
	}
	return nil
}

type ManagerUpdateVodResponse struct {
	// vod is the vod response
	Vod *Vod `protobuf:"bytes,1,opt,name=vod" json:"vod,omitempty"`
}

func (m *ManagerUpdateVodResponse) Reset()                    { *m = ManagerUpdateVodResponse{} }
func (m *ManagerUpdateVodResponse) String() string            { return proto.CompactTextString(m) }
func (*ManagerUpdateVodResponse) ProtoMessage()               {}
func (*ManagerUpdateVodResponse) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{33} }

func (m *ManagerUpdateVodResponse) GetVod() *Vod {
	if m != nil {
		return m.Vod
	}
	return nil
}

type UndeleteVodsResponse struct {
	// vods is the vods response
	Vods []*Vod `protobuf:"bytes,1,rep,name=vods" json:"vods,omitempty"`
}

func (m *UndeleteVodsResponse) Reset()                    { *m = UndeleteVodsResponse{} }
func (m *UndeleteVodsResponse) String() string            { return proto.CompactTextString(m) }
func (*UndeleteVodsResponse) ProtoMessage()               {}
func (*UndeleteVodsResponse) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{34} }

func (m *UndeleteVodsResponse) GetVods() []*Vod {
	if m != nil {
		return m.Vods
	}
	return nil
}

type SoftDeleteVodsResponse struct {
	// vods is the vods response
	Vods []*Vod `protobuf:"bytes,1,rep,name=vods" json:"vods,omitempty"`
}

func (m *SoftDeleteVodsResponse) Reset()                    { *m = SoftDeleteVodsResponse{} }
func (m *SoftDeleteVodsResponse) String() string            { return proto.CompactTextString(m) }
func (*SoftDeleteVodsResponse) ProtoMessage()               {}
func (*SoftDeleteVodsResponse) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{35} }

func (m *SoftDeleteVodsResponse) GetVods() []*Vod {
	if m != nil {
		return m.Vods
	}
	return nil
}

type InternalVodRemoveRecordsResponse struct {
	// vods is the vods response
	Vods []*Vod `protobuf:"bytes,1,rep,name=vods" json:"vods,omitempty"`
}

func (m *InternalVodRemoveRecordsResponse) Reset()         { *m = InternalVodRemoveRecordsResponse{} }
func (m *InternalVodRemoveRecordsResponse) String() string { return proto.CompactTextString(m) }
func (*InternalVodRemoveRecordsResponse) ProtoMessage()    {}
func (*InternalVodRemoveRecordsResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor0, []int{36}
}

func (m *InternalVodRemoveRecordsResponse) GetVods() []*Vod {
	if m != nil {
		return m.Vods
	}
	return nil
}

type HardDeleteVodsResponse struct {
	// vods is the vods response
	Vods []*Vod `protobuf:"bytes,1,rep,name=vods" json:"vods,omitempty"`
}

func (m *HardDeleteVodsResponse) Reset()                    { *m = HardDeleteVodsResponse{} }
func (m *HardDeleteVodsResponse) String() string            { return proto.CompactTextString(m) }
func (*HardDeleteVodsResponse) ProtoMessage()               {}
func (*HardDeleteVodsResponse) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{37} }

func (m *HardDeleteVodsResponse) GetVods() []*Vod {
	if m != nil {
		return m.Vods
	}
	return nil
}

// empty response object to allow future fields without breaking the api
type SoftDeleteVodsInIntervalResponse struct {
}

func (m *SoftDeleteVodsInIntervalResponse) Reset()         { *m = SoftDeleteVodsInIntervalResponse{} }
func (m *SoftDeleteVodsInIntervalResponse) String() string { return proto.CompactTextString(m) }
func (*SoftDeleteVodsInIntervalResponse) ProtoMessage()    {}
func (*SoftDeleteVodsInIntervalResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor0, []int{38}
}

type ManagerSoftDeleteVodsResponse struct {
	// vods is the vods response
	Vods []*Vod `protobuf:"bytes,1,rep,name=vods" json:"vods,omitempty"`
}

func (m *ManagerSoftDeleteVodsResponse) Reset()                    { *m = ManagerSoftDeleteVodsResponse{} }
func (m *ManagerSoftDeleteVodsResponse) String() string            { return proto.CompactTextString(m) }
func (*ManagerSoftDeleteVodsResponse) ProtoMessage()               {}
func (*ManagerSoftDeleteVodsResponse) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{39} }

func (m *ManagerSoftDeleteVodsResponse) GetVods() []*Vod {
	if m != nil {
		return m.Vods
	}
	return nil
}

// empty response object to allow future fields without breaking the api
type YoutubeExportResponse struct {
}

func (m *YoutubeExportResponse) Reset()                    { *m = YoutubeExportResponse{} }
func (m *YoutubeExportResponse) String() string            { return proto.CompactTextString(m) }
func (*YoutubeExportResponse) ProtoMessage()               {}
func (*YoutubeExportResponse) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{40} }

// empty response object to allow future fields without breaking the api
type FinalizeUploadResponse struct {
}

func (m *FinalizeUploadResponse) Reset()                    { *m = FinalizeUploadResponse{} }
func (m *FinalizeUploadResponse) String() string            { return proto.CompactTextString(m) }
func (*FinalizeUploadResponse) ProtoMessage()               {}
func (*FinalizeUploadResponse) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{41} }

// empty response object to allow future fields without breaking the api
type UpdateManifestResponse struct {
}

func (m *UpdateManifestResponse) Reset()                    { *m = UpdateManifestResponse{} }
func (m *UpdateManifestResponse) String() string            { return proto.CompactTextString(m) }
func (*UpdateManifestResponse) ProtoMessage()               {}
func (*UpdateManifestResponse) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{42} }

// empty response object to allow future fields without breaking the api
type SetViewcountsResponse struct {
}

func (m *SetViewcountsResponse) Reset()                    { *m = SetViewcountsResponse{} }
func (m *SetViewcountsResponse) String() string            { return proto.CompactTextString(m) }
func (*SetViewcountsResponse) ProtoMessage()               {}
func (*SetViewcountsResponse) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{43} }

type PublicVodAggregationsByIDsResponse struct {
	// total_count is the total count of vods
	TotalCount int64 `protobuf:"varint,1,opt,name=total_count,json=totalCount" json:"total_count,omitempty"`
	// total_duration is the total duration of vods
	TotalDuration int64 `protobuf:"varint,2,opt,name=total_duration,json=totalDuration" json:"total_duration,omitempty"`
}

func (m *PublicVodAggregationsByIDsResponse) Reset()         { *m = PublicVodAggregationsByIDsResponse{} }
func (m *PublicVodAggregationsByIDsResponse) String() string { return proto.CompactTextString(m) }
func (*PublicVodAggregationsByIDsResponse) ProtoMessage()    {}
func (*PublicVodAggregationsByIDsResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor0, []int{44}
}

func (m *PublicVodAggregationsByIDsResponse) GetTotalCount() int64 {
	if m != nil {
		return m.TotalCount
	}
	return 0
}

func (m *PublicVodAggregationsByIDsResponse) GetTotalDuration() int64 {
	if m != nil {
		return m.TotalDuration
	}
	return 0
}

type VodPopularityResponse struct {
	// popular is whether the vod is popular
	Popular bool `protobuf:"varint,1,opt,name=popular" json:"popular,omitempty"`
}

func (m *VodPopularityResponse) Reset()                    { *m = VodPopularityResponse{} }
func (m *VodPopularityResponse) String() string            { return proto.CompactTextString(m) }
func (*VodPopularityResponse) ProtoMessage()               {}
func (*VodPopularityResponse) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{45} }

func (m *VodPopularityResponse) GetPopular() bool {
	if m != nil {
		return m.Popular
	}
	return false
}

type CreateErrorResponse struct {
	// vod_id is the id of the vod that is being requested
	VodId string `protobuf:"bytes,1,opt,name=vod_id,json=vodId" json:"vod_id,omitempty"`
	// error_code is the error code
	ErrorCode string `protobuf:"bytes,2,opt,name=error_code,json=errorCode" json:"error_code,omitempty"`
	// error_message is the error message
	ErrorMessage string `protobuf:"bytes,3,opt,name=error_message,json=errorMessage" json:"error_message,omitempty"`
	// created_at is when the property was created
	CreatedAt *google_protobuf1.Timestamp `protobuf:"bytes,4,opt,name=created_at,json=createdAt" json:"created_at,omitempty"`
}

func (m *CreateErrorResponse) Reset()                    { *m = CreateErrorResponse{} }
func (m *CreateErrorResponse) String() string            { return proto.CompactTextString(m) }
func (*CreateErrorResponse) ProtoMessage()               {}
func (*CreateErrorResponse) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{46} }

func (m *CreateErrorResponse) GetVodId() string {
	if m != nil {
		return m.VodId
	}
	return ""
}

func (m *CreateErrorResponse) GetErrorCode() string {
	if m != nil {
		return m.ErrorCode
	}
	return ""
}

func (m *CreateErrorResponse) GetErrorMessage() string {
	if m != nil {
		return m.ErrorMessage
	}
	return ""
}

func (m *CreateErrorResponse) GetCreatedAt() *google_protobuf1.Timestamp {
	if m != nil {
		return m.CreatedAt
	}
	return nil
}

type CreateThumbnailsResponse struct {
	// thumbnails is the list of thumbnails
	Thumbnails []*Thumbnail `protobuf:"bytes,1,rep,name=thumbnails" json:"thumbnails,omitempty"`
}

func (m *CreateThumbnailsResponse) Reset()                    { *m = CreateThumbnailsResponse{} }
func (m *CreateThumbnailsResponse) String() string            { return proto.CompactTextString(m) }
func (*CreateThumbnailsResponse) ProtoMessage()               {}
func (*CreateThumbnailsResponse) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{47} }

func (m *CreateThumbnailsResponse) GetThumbnails() []*Thumbnail {
	if m != nil {
		return m.Thumbnails
	}
	return nil
}

type CreateCustomThumbnailUploadRequestResponse struct {
	// url is the url for the custom thumbnail upload
	Url string `protobuf:"bytes,1,opt,name=url" json:"url,omitempty"`
	// upload_id is upload id for the thumbnail request
	UploadId string `protobuf:"bytes,2,opt,name=upload_id,json=uploadId" json:"upload_id,omitempty"`
}

func (m *CreateCustomThumbnailUploadRequestResponse) Reset() {
	*m = CreateCustomThumbnailUploadRequestResponse{}
}
func (m *CreateCustomThumbnailUploadRequestResponse) String() string {
	return proto.CompactTextString(m)
}
func (*CreateCustomThumbnailUploadRequestResponse) ProtoMessage() {}
func (*CreateCustomThumbnailUploadRequestResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor0, []int{48}
}

func (m *CreateCustomThumbnailUploadRequestResponse) GetUrl() string {
	if m != nil {
		return m.Url
	}
	return ""
}

func (m *CreateCustomThumbnailUploadRequestResponse) GetUploadId() string {
	if m != nil {
		return m.UploadId
	}
	return ""
}

// empty response object to allow future fields without breaking the api
type ManagerDeleteThumbnailsResponse struct {
}

func (m *ManagerDeleteThumbnailsResponse) Reset()         { *m = ManagerDeleteThumbnailsResponse{} }
func (m *ManagerDeleteThumbnailsResponse) String() string { return proto.CompactTextString(m) }
func (*ManagerDeleteThumbnailsResponse) ProtoMessage()    {}
func (*ManagerDeleteThumbnailsResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor0, []int{49}
}

// empty response object to allow future fields without breaking the api
type DeleteThumbnailsResponse struct {
}

func (m *DeleteThumbnailsResponse) Reset()                    { *m = DeleteThumbnailsResponse{} }
func (m *DeleteThumbnailsResponse) String() string            { return proto.CompactTextString(m) }
func (*DeleteThumbnailsResponse) ProtoMessage()               {}
func (*DeleteThumbnailsResponse) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{50} }

type UserVodPropertiesResponse struct {
	// channel_id is the channel for the properties
	ChannelId string `protobuf:"bytes,1,opt,name=channel_id,json=channelId" json:"channel_id,omitempty"`
	// save_vods_forever is a flag to indicate if vods should be saved forever
	SaveVodsForever bool `protobuf:"varint,2,opt,name=save_vods_forever,json=saveVodsForever" json:"save_vods_forever,omitempty"`
	// vod_storage_days is how many days a vod should be stored
	VodStorageDays int64 `protobuf:"varint,3,opt,name=vod_storage_days,json=vodStorageDays" json:"vod_storage_days,omitempty"`
	// can_upload_vod is a flag to indicate if the user can upload vods
	CanUploadVod bool `protobuf:"varint,4,opt,name=can_upload_vod,json=canUploadVod" json:"can_upload_vod,omitempty"`
	// youtube_exporting_disabled is a flag to indicate if the user can export to youtube
	YoutubeExportingDisabled bool `protobuf:"varint,5,opt,name=youtube_exporting_disabled,json=youtubeExportingDisabled" json:"youtube_exporting_disabled,omitempty"`
	// skip_upload_moderation is a flag to indicate if the user's vods skip moderation
	SkipUploadModeration bool `protobuf:"varint,6,opt,name=skip_upload_moderation,json=skipUploadModeration" json:"skip_upload_moderation,omitempty"`
	// skip_muting is a flag to indicate if the user's vods skip muting
	SkipMuting bool `protobuf:"varint,7,opt,name=skip_muting,json=skipMuting" json:"skip_muting,omitempty"`
	// can_upload_vod is a flag to indicate if the user can upload unlimited vods
	CanUploadUnlimited bool `protobuf:"varint,8,opt,name=can_upload_unlimited,json=canUploadUnlimited" json:"can_upload_unlimited,omitempty"`
	// created_at is when the property was created
	CreatedAt *google_protobuf1.Timestamp `protobuf:"bytes,9,opt,name=created_at,json=createdAt" json:"created_at,omitempty"`
	// updated_at is when the property was updated
	UpdatedAt *google_protobuf1.Timestamp `protobuf:"bytes,10,opt,name=updated_at,json=updatedAt" json:"updated_at,omitempty"`
}

func (m *UserVodPropertiesResponse) Reset()                    { *m = UserVodPropertiesResponse{} }
func (m *UserVodPropertiesResponse) String() string            { return proto.CompactTextString(m) }
func (*UserVodPropertiesResponse) ProtoMessage()               {}
func (*UserVodPropertiesResponse) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{51} }

func (m *UserVodPropertiesResponse) GetChannelId() string {
	if m != nil {
		return m.ChannelId
	}
	return ""
}

func (m *UserVodPropertiesResponse) GetSaveVodsForever() bool {
	if m != nil {
		return m.SaveVodsForever
	}
	return false
}

func (m *UserVodPropertiesResponse) GetVodStorageDays() int64 {
	if m != nil {
		return m.VodStorageDays
	}
	return 0
}

func (m *UserVodPropertiesResponse) GetCanUploadVod() bool {
	if m != nil {
		return m.CanUploadVod
	}
	return false
}

func (m *UserVodPropertiesResponse) GetYoutubeExportingDisabled() bool {
	if m != nil {
		return m.YoutubeExportingDisabled
	}
	return false
}

func (m *UserVodPropertiesResponse) GetSkipUploadModeration() bool {
	if m != nil {
		return m.SkipUploadModeration
	}
	return false
}

func (m *UserVodPropertiesResponse) GetSkipMuting() bool {
	if m != nil {
		return m.SkipMuting
	}
	return false
}

func (m *UserVodPropertiesResponse) GetCanUploadUnlimited() bool {
	if m != nil {
		return m.CanUploadUnlimited
	}
	return false
}

func (m *UserVodPropertiesResponse) GetCreatedAt() *google_protobuf1.Timestamp {
	if m != nil {
		return m.CreatedAt
	}
	return nil
}

func (m *UserVodPropertiesResponse) GetUpdatedAt() *google_protobuf1.Timestamp {
	if m != nil {
		return m.UpdatedAt
	}
	return nil
}

type UserVideoPrivacyPropertiesResponse struct {
	// channel_id is the channel for the properties
	ChannelId string `protobuf:"bytes,1,opt,name=channel_id,json=channelId" json:"channel_id,omitempty"`
	// hide_archives is whether the archives are hidden
	HideArchives bool `protobuf:"varint,2,opt,name=hide_archives,json=hideArchives" json:"hide_archives,omitempty"`
	// hide_archives is whether the hide archives is enabled
	HideArchivesEnabled bool `protobuf:"varint,3,opt,name=hide_archives_enabled,json=hideArchivesEnabled" json:"hide_archives_enabled,omitempty"`
	// created_at is when the property was created
	CreatedAt *google_protobuf1.Timestamp `protobuf:"bytes,4,opt,name=created_at,json=createdAt" json:"created_at,omitempty"`
	// updated_at is when the property was updated
	UpdatedAt *google_protobuf1.Timestamp `protobuf:"bytes,5,opt,name=updated_at,json=updatedAt" json:"updated_at,omitempty"`
}

func (m *UserVideoPrivacyPropertiesResponse) Reset()         { *m = UserVideoPrivacyPropertiesResponse{} }
func (m *UserVideoPrivacyPropertiesResponse) String() string { return proto.CompactTextString(m) }
func (*UserVideoPrivacyPropertiesResponse) ProtoMessage()    {}
func (*UserVideoPrivacyPropertiesResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor0, []int{52}
}

func (m *UserVideoPrivacyPropertiesResponse) GetChannelId() string {
	if m != nil {
		return m.ChannelId
	}
	return ""
}

func (m *UserVideoPrivacyPropertiesResponse) GetHideArchives() bool {
	if m != nil {
		return m.HideArchives
	}
	return false
}

func (m *UserVideoPrivacyPropertiesResponse) GetHideArchivesEnabled() bool {
	if m != nil {
		return m.HideArchivesEnabled
	}
	return false
}

func (m *UserVideoPrivacyPropertiesResponse) GetCreatedAt() *google_protobuf1.Timestamp {
	if m != nil {
		return m.CreatedAt
	}
	return nil
}

func (m *UserVideoPrivacyPropertiesResponse) GetUpdatedAt() *google_protobuf1.Timestamp {
	if m != nil {
		return m.UpdatedAt
	}
	return nil
}

// empty response object to allow future fields without breaking the api
type CreateVodAppealsResponse struct {
}

func (m *CreateVodAppealsResponse) Reset()                    { *m = CreateVodAppealsResponse{} }
func (m *CreateVodAppealsResponse) String() string            { return proto.CompactTextString(m) }
func (*CreateVodAppealsResponse) ProtoMessage()               {}
func (*CreateVodAppealsResponse) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{53} }

type VodAppealsResponse struct {
	// total_count is the total count of appeals
	TotalCount int64 `protobuf:"varint,1,opt,name=total_count,json=totalCount" json:"total_count,omitempty"`
	// appeals is the list of appeals
	Appeals []*VodAppeal `protobuf:"bytes,2,rep,name=appeals" json:"appeals,omitempty"`
}

func (m *VodAppealsResponse) Reset()                    { *m = VodAppealsResponse{} }
func (m *VodAppealsResponse) String() string            { return proto.CompactTextString(m) }
func (*VodAppealsResponse) ProtoMessage()               {}
func (*VodAppealsResponse) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{54} }

func (m *VodAppealsResponse) GetTotalCount() int64 {
	if m != nil {
		return m.TotalCount
	}
	return 0
}

func (m *VodAppealsResponse) GetAppeals() []*VodAppeal {
	if m != nil {
		return m.Appeals
	}
	return nil
}

// empty response object to allow future fields without breaking the api
type ResolveTrackAppealResponse struct {
}

func (m *ResolveTrackAppealResponse) Reset()                    { *m = ResolveTrackAppealResponse{} }
func (m *ResolveTrackAppealResponse) String() string            { return proto.CompactTextString(m) }
func (*ResolveTrackAppealResponse) ProtoMessage()               {}
func (*ResolveTrackAppealResponse) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{55} }

// empty response object to allow future fields without breaking the api
type ResolveVodAppealResponse struct {
}

func (m *ResolveVodAppealResponse) Reset()                    { *m = ResolveVodAppealResponse{} }
func (m *ResolveVodAppealResponse) String() string            { return proto.CompactTextString(m) }
func (*ResolveVodAppealResponse) ProtoMessage()               {}
func (*ResolveVodAppealResponse) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{56} }

type AudibleMagicResponsesResponse struct {
	// audible_magic_responses is the list of audible magic responses
	AudibleMagicResponses []*AudibleMagicResponse `protobuf:"bytes,1,rep,name=audible_magic_responses,json=audibleMagicResponses" json:"audible_magic_responses,omitempty"`
}

func (m *AudibleMagicResponsesResponse) Reset()                    { *m = AudibleMagicResponsesResponse{} }
func (m *AudibleMagicResponsesResponse) String() string            { return proto.CompactTextString(m) }
func (*AudibleMagicResponsesResponse) ProtoMessage()               {}
func (*AudibleMagicResponsesResponse) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{57} }

func (m *AudibleMagicResponsesResponse) GetAudibleMagicResponses() []*AudibleMagicResponse {
	if m != nil {
		return m.AudibleMagicResponses
	}
	return nil
}

func init() {
	proto.RegisterType((*ShowFormat)(nil), "vodapi.ShowFormat")
	proto.RegisterType((*Thumbnail)(nil), "vodapi.Thumbnail")
	proto.RegisterType((*ThumbnailTemplate)(nil), "vodapi.ThumbnailTemplate")
	proto.RegisterType((*AudibleMagicResponse)(nil), "vodapi.AudibleMagicResponse")
	proto.RegisterType((*VodMutedSegment)(nil), "vodapi.VodMutedSegment")
	proto.RegisterType((*VodAppeal)(nil), "vodapi.VodAppeal")
	proto.RegisterType((*TrackAppeal)(nil), "vodapi.TrackAppeal")
	proto.RegisterType((*VodNotificationSetting)(nil), "vodapi.VodNotificationSetting")
	proto.RegisterType((*VodNotificationSettingsMap)(nil), "vodapi.VodNotificationSettingsMap")
	proto.RegisterType((*Vod)(nil), "vodapi.Vod")
	proto.RegisterType((*CreateUploadResponse)(nil), "vodapi.CreateUploadResponse")
	proto.RegisterType((*CreateArchiveResponse)(nil), "vodapi.CreateArchiveResponse")
	proto.RegisterType((*InternalCreateHighlightResponse)(nil), "vodapi.InternalCreateHighlightResponse")
	proto.RegisterType((*ManagerCreateHighlightResponse)(nil), "vodapi.ManagerCreateHighlightResponse")
	proto.RegisterType((*PublicGetVodByIDResponse)(nil), "vodapi.PublicGetVodByIDResponse")
	proto.RegisterType((*InternalGetVodByIDResponse)(nil), "vodapi.InternalGetVodByIDResponse")
	proto.RegisterType((*ManagerInternalGetVodByIDResponse)(nil), "vodapi.ManagerInternalGetVodByIDResponse")
	proto.RegisterType((*VodMuteInfoResponse)(nil), "vodapi.VodMuteInfoResponse")
	proto.RegisterType((*ManagerGetVodMuteInfoResponse)(nil), "vodapi.ManagerGetVodMuteInfoResponse")
	proto.RegisterType((*InternalGetVodMuteInfoResponse)(nil), "vodapi.InternalGetVodMuteInfoResponse")
	proto.RegisterType((*ManagerGetVodMuteInfosResponse)(nil), "vodapi.ManagerGetVodMuteInfosResponse")
	proto.RegisterType((*GetVodByIDIncludeBannedUsersResponse)(nil), "vodapi.GetVodByIDIncludeBannedUsersResponse")
	proto.RegisterType((*ManagerGetVodByIDResponse)(nil), "vodapi.ManagerGetVodByIDResponse")
	proto.RegisterType((*ManagerSearchVodsResponse)(nil), "vodapi.ManagerSearchVodsResponse")
	proto.RegisterType((*PublicGetVodsByUserResponse)(nil), "vodapi.PublicGetVodsByUserResponse")
	proto.RegisterType((*ManagerInternalGetVodsByUserResponse)(nil), "vodapi.ManagerInternalGetVodsByUserResponse")
	proto.RegisterType((*ManagerGetVodsByUserIncludeBannedUsersResponse)(nil), "vodapi.ManagerGetVodsByUserIncludeBannedUsersResponse")
	proto.RegisterType((*InternalGetVodsByBroadcastIDsResponse)(nil), "vodapi.InternalGetVodsByBroadcastIDsResponse")
	proto.RegisterType((*PublicGetVodsByIDsResponse)(nil), "vodapi.PublicGetVodsByIDsResponse")
	proto.RegisterType((*InternalGetVodsByIDsResponse)(nil), "vodapi.InternalGetVodsByIDsResponse")
	proto.RegisterType((*GetVodsByIDsIncludeBannedUsersResponse)(nil), "vodapi.GetVodsByIDsIncludeBannedUsersResponse")
	proto.RegisterType((*PublicGetVodsByUsersResponse)(nil), "vodapi.PublicGetVodsByUsersResponse")
	proto.RegisterType((*GetTopVodsResponse)(nil), "vodapi.GetTopVodsResponse")
	proto.RegisterType((*ManagerUpdateVodResponse)(nil), "vodapi.ManagerUpdateVodResponse")
	proto.RegisterType((*UndeleteVodsResponse)(nil), "vodapi.UndeleteVodsResponse")
	proto.RegisterType((*SoftDeleteVodsResponse)(nil), "vodapi.SoftDeleteVodsResponse")
	proto.RegisterType((*InternalVodRemoveRecordsResponse)(nil), "vodapi.InternalVodRemoveRecordsResponse")
	proto.RegisterType((*HardDeleteVodsResponse)(nil), "vodapi.HardDeleteVodsResponse")
	proto.RegisterType((*SoftDeleteVodsInIntervalResponse)(nil), "vodapi.SoftDeleteVodsInIntervalResponse")
	proto.RegisterType((*ManagerSoftDeleteVodsResponse)(nil), "vodapi.ManagerSoftDeleteVodsResponse")
	proto.RegisterType((*YoutubeExportResponse)(nil), "vodapi.YoutubeExportResponse")
	proto.RegisterType((*FinalizeUploadResponse)(nil), "vodapi.FinalizeUploadResponse")
	proto.RegisterType((*UpdateManifestResponse)(nil), "vodapi.UpdateManifestResponse")
	proto.RegisterType((*SetViewcountsResponse)(nil), "vodapi.SetViewcountsResponse")
	proto.RegisterType((*PublicVodAggregationsByIDsResponse)(nil), "vodapi.PublicVodAggregationsByIDsResponse")
	proto.RegisterType((*VodPopularityResponse)(nil), "vodapi.VodPopularityResponse")
	proto.RegisterType((*CreateErrorResponse)(nil), "vodapi.CreateErrorResponse")
	proto.RegisterType((*CreateThumbnailsResponse)(nil), "vodapi.CreateThumbnailsResponse")
	proto.RegisterType((*CreateCustomThumbnailUploadRequestResponse)(nil), "vodapi.CreateCustomThumbnailUploadRequestResponse")
	proto.RegisterType((*ManagerDeleteThumbnailsResponse)(nil), "vodapi.ManagerDeleteThumbnailsResponse")
	proto.RegisterType((*DeleteThumbnailsResponse)(nil), "vodapi.DeleteThumbnailsResponse")
	proto.RegisterType((*UserVodPropertiesResponse)(nil), "vodapi.UserVodPropertiesResponse")
	proto.RegisterType((*UserVideoPrivacyPropertiesResponse)(nil), "vodapi.UserVideoPrivacyPropertiesResponse")
	proto.RegisterType((*CreateVodAppealsResponse)(nil), "vodapi.CreateVodAppealsResponse")
	proto.RegisterType((*VodAppealsResponse)(nil), "vodapi.VodAppealsResponse")
	proto.RegisterType((*ResolveTrackAppealResponse)(nil), "vodapi.ResolveTrackAppealResponse")
	proto.RegisterType((*ResolveVodAppealResponse)(nil), "vodapi.ResolveVodAppealResponse")
	proto.RegisterType((*AudibleMagicResponsesResponse)(nil), "vodapi.AudibleMagicResponsesResponse")
}

func init() { proto.RegisterFile("responses.proto", fileDescriptor0) }

var fileDescriptor0 = []byte{
	// 3014 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xac, 0x1a, 0xd9, 0x72, 0x1b, 0xc7,
	0xb1, 0x40, 0xf0, 0x00, 0x1a, 0x3c, 0x87, 0x87, 0x56, 0x10, 0x25, 0x51, 0x6b, 0x59, 0xa1, 0x8f,
	0x50, 0x16, 0x2d, 0xcb, 0x92, 0x0f, 0xc9, 0xa4, 0xa8, 0x03, 0xb1, 0x69, 0xc9, 0xcb, 0x23, 0x65,
	0x27, 0x55, 0x5b, 0xc3, 0xdd, 0x01, 0xb0, 0xa5, 0xdd, 0x9d, 0xf5, 0xce, 0x2c, 0x29, 0xf8, 0x25,
	0xdf, 0x90, 0x54, 0xe5, 0x2b, 0xf2, 0x9e, 0x7f, 0xc8, 0x57, 0xa4, 0x2a, 0x1f, 0x90, 0x97, 0x3c,
	0xe6, 0x25, 0x35, 0xd7, 0x62, 0x01, 0x50, 0x04, 0x40, 0xe7, 0x0d, 0xd3, 0xd7, 0xf4, 0x74, 0xf7,
	0xf4, 0x74, 0xf7, 0x02, 0x16, 0x52, 0xc2, 0x12, 0x1a, 0x33, 0xc2, 0xb6, 0x92, 0x94, 0x72, 0x8a,
	0xa6, 0x4f, 0xa9, 0x8f, 0x93, 0xa0, 0x7e, 0xa3, 0x45, 0x69, 0x2b, 0x24, 0x77, 0x25, 0xf4, 0x24,
	0x6b, 0xde, 0x3d, 0x4b, 0x71, 0x92, 0x90, 0x54, 0xd3, 0xd5, 0x6f, 0xf6, 0xe3, 0x79, 0x10, 0x11,
	0xc6, 0x71, 0x94, 0x68, 0x82, 0x59, 0x8f, 0xc6, 0x8c, 0x6b, 0x72, 0xfb, 0xdf, 0x25, 0x80, 0x83,
	0x36, 0x3d, 0x7b, 0x4e, 0xd3, 0x08, 0x73, 0x74, 0x17, 0x96, 0x93, 0x10, 0x77, 0xc2, 0x80, 0x71,
	0x37, 0x49, 0x49, 0x93, 0xa4, 0x24, 0xf6, 0x88, 0x55, 0xda, 0x28, 0x6d, 0x96, 0x1d, 0x64, 0x50,
	0xaf, 0x73, 0x0c, 0xba, 0x05, 0xb3, 0x7e, 0xc0, 0x04, 0xc2, 0x8d, 0x71, 0x44, 0xac, 0x89, 0x8d,
	0xd2, 0x66, 0xd5, 0xa9, 0x69, 0xd8, 0xf7, 0x38, 0x22, 0xc8, 0x82, 0x99, 0x93, 0x80, 0xa7, 0x98,
	0x13, 0xab, 0x2c, 0xe5, 0x98, 0x25, 0x5a, 0x84, 0x72, 0x33, 0x61, 0xd6, 0xe4, 0x46, 0x69, 0xb3,
	0xe4, 0x88, 0x9f, 0x68, 0x13, 0x16, 0x23, 0xfc, 0xd6, 0x0d, 0xfc, 0xd4, 0x0d, 0x62, 0x4e, 0xd2,
	0x53, 0x1c, 0x5a, 0x53, 0x92, 0x69, 0x3e, 0xc2, 0x6f, 0x1b, 0x7e, 0xda, 0xd0, 0x50, 0xb4, 0x06,
	0xd3, 0x1e, 0xf5, 0x89, 0xc7, 0xac, 0x69, 0xb9, 0xa5, 0x5e, 0xa1, 0x1b, 0x00, 0x29, 0x61, 0x34,
	0xcc, 0x78, 0x40, 0x63, 0x6b, 0x46, 0xe2, 0x0a, 0x10, 0xfb, 0x08, 0xaa, 0x87, 0xed, 0x2c, 0x3a,
	0x89, 0x71, 0x10, 0x22, 0x04, 0x93, 0x09, 0xe6, 0x6d, 0x79, 0xbe, 0xaa, 0x23, 0x7f, 0xa3, 0xfb,
	0x30, 0x4d, 0x9b, 0x4d, 0x46, 0xb8, 0x3c, 0x4b, 0x6d, 0x7b, 0x7d, 0x4b, 0x59, 0x74, 0xcb, 0x58,
	0x74, 0x6b, 0x8f, 0x66, 0x27, 0x21, 0x39, 0xc6, 0x61, 0x46, 0x1c, 0x4d, 0x6b, 0xff, 0x09, 0x96,
	0x72, 0xb1, 0x87, 0x24, 0x4a, 0x42, 0x71, 0xbe, 0xb5, 0x5c, 0x54, 0x49, 0x1e, 0x51, 0xaf, 0xf2,
	0x6d, 0x27, 0x0a, 0xdb, 0x7e, 0x0c, 0x93, 0xbc, 0x93, 0x28, 0x13, 0xcd, 0x6f, 0x5b, 0x5b, 0xca,
	0xdd, 0x5b, 0xc7, 0xd4, 0xef, 0xca, 0xed, 0x24, 0xc4, 0x91, 0x54, 0xc2, 0x72, 0x59, 0x1a, 0x4a,
	0xcb, 0x55, 0x1d, 0xf1, 0xd3, 0xfe, 0x73, 0x05, 0x56, 0x76, 0x32, 0x3f, 0x38, 0x09, 0xc9, 0x3e,
	0x6e, 0x05, 0x9e, 0xa3, 0xe3, 0x07, 0x3d, 0x82, 0xab, 0x58, 0xc1, 0xdd, 0x48, 0x20, 0x5c, 0x13,
	0x59, 0x6e, 0xe0, 0xeb, 0x83, 0xaf, 0xe1, 0x73, 0x18, 0x1b, 0x3e, 0x5a, 0x05, 0x11, 0x75, 0x82,
	0x4e, 0x69, 0x3a, 0x75, 0x4a, 0xfd, 0x86, 0x8f, 0x56, 0x60, 0x8a, 0x07, 0x3c, 0x54, 0xba, 0x56,
	0x1d, 0xb5, 0x40, 0xeb, 0x50, 0x4d, 0x48, 0xda, 0xa4, 0x69, 0x44, 0x52, 0xad, 0x58, 0x17, 0x20,
	0x78, 0x5a, 0x24, 0x4e, 0x89, 0xf4, 0x66, 0xd5, 0x51, 0x0b, 0x61, 0x20, 0x9c, 0xf2, 0x80, 0x71,
	0xe3, 0x44, 0xb5, 0x42, 0x37, 0xa1, 0x86, 0xc3, 0x93, 0x2c, 0x72, 0xd5, 0x3e, 0xda, 0x8b, 0x12,
	0x74, 0x28, 0x37, 0x43, 0x30, 0xc9, 0x68, 0xdc, 0xb2, 0x2a, 0xca, 0x82, 0xe2, 0xb7, 0x80, 0x05,
	0x2c, 0xf5, 0xac, 0xaa, 0x82, 0x89, 0xdf, 0xe8, 0x2a, 0x54, 0x02, 0xe6, 0x46, 0x98, 0x7b, 0x6d,
	0x0b, 0x36, 0x4a, 0x9b, 0x15, 0x67, 0x26, 0x60, 0xfb, 0x62, 0x89, 0xf6, 0x61, 0x45, 0xc2, 0x5d,
	0xe5, 0x14, 0x97, 0x11, 0x8f, 0xc6, 0x3e, 0xb3, 0x6a, 0xd2, 0xeb, 0xd7, 0x06, 0xbc, 0xde, 0x88,
	0xf9, 0x83, 0xfb, 0xca, 0xe9, 0x48, 0x32, 0xbe, 0x92, 0x7c, 0x07, 0x8a, 0x0d, 0xfd, 0x00, 0x6b,
	0x4a, 0x9c, 0x9f, 0xa5, 0x58, 0x44, 0x5a, 0x2e, 0x70, 0x76, 0xb8, 0x40, 0xa5, 0xc9, 0x9e, 0xe6,
	0x34, 0x22, 0xbf, 0x85, 0x65, 0xe6, 0xe1, 0xb8, 0x5f, 0xc1, 0xb9, 0xe1, 0xf2, 0x96, 0x04, 0x5f,
	0xaf, 0x7e, 0xaf, 0x60, 0x55, 0x0a, 0x1b, 0x50, 0x6f, 0x7e, 0xb8, 0x38, 0xa9, 0xc6, 0x39, 0xda,
	0x45, 0x19, 0x27, 0xfd, 0xda, 0x2d, 0x8c, 0xa0, 0x9d, 0xe0, 0x1b, 0xd0, 0x4e, 0x0a, 0x1b, 0xd0,
	0x6e, 0x71, 0x04, 0xed, 0x04, 0x67, 0xbf, 0x76, 0xf7, 0x60, 0xb5, 0x37, 0xea, 0x03, 0x4e, 0x22,
	0x11, 0xc9, 0x4b, 0x32, 0x3a, 0x50, 0x31, 0xe2, 0x1b, 0x9c, 0x44, 0x0d, 0x1f, 0x3d, 0x02, 0xf0,
	0x52, 0x82, 0x39, 0xf1, 0x5d, 0xcc, 0x2d, 0x24, 0x37, 0xae, 0x0f, 0x6c, 0x7c, 0x68, 0xd2, 0xa9,
	0x53, 0xd5, 0xd4, 0x3b, 0x5c, 0xb0, 0x66, 0x89, 0x6f, 0x58, 0x97, 0x87, 0xb3, 0x6a, 0xea, 0x1d,
	0x19, 0xea, 0x22, 0x7a, 0xdd, 0x90, 0xc4, 0x2d, 0xde, 0xb6, 0x56, 0x64, 0xb2, 0x03, 0x01, 0xfa,
	0x4e, 0x42, 0xa4, 0xec, 0x58, 0x1c, 0x51, 0xca, 0x5e, 0x1d, 0x41, 0xb6, 0xa2, 0xde, 0xe1, 0xf6,
	0x33, 0x58, 0x38, 0xa6, 0xfe, 0xbe, 0x58, 0x1d, 0x90, 0x56, 0x44, 0x62, 0xde, 0x97, 0x92, 0xca,
	0x79, 0x4a, 0xaa, 0x43, 0xc5, 0xd8, 0x5e, 0x5e, 0xf6, 0xb2, 0x93, 0xaf, 0xed, 0x7f, 0x95, 0xa1,
	0x7a, 0x4c, 0xfd, 0x9d, 0x24, 0x21, 0x38, 0x44, 0x36, 0xcc, 0x89, 0xa4, 0x80, 0xe5, 0xaa, 0x9b,
	0x43, 0x6a, 0xa7, 0x86, 0xa2, 0xe1, 0xa3, 0x2f, 0xa1, 0x26, 0x53, 0xee, 0xa9, 0x52, 0x7a, 0x62,
	0xa8, 0xd2, 0x60, 0xc8, 0x95, 0x31, 0x0b, 0x7e, 0x28, 0x5f, 0xde, 0x0f, 0x93, 0xe3, 0xf8, 0xa1,
	0x9b, 0xeb, 0xa6, 0x8a, 0xb9, 0xae, 0x0e, 0x95, 0x24, 0x0d, 0x68, 0x1a, 0xf0, 0x8e, 0xcc, 0x51,
	0x15, 0x27, 0x5f, 0xa3, 0x6b, 0x50, 0x6d, 0x66, 0x61, 0xa8, 0x1e, 0x3e, 0x95, 0xa3, 0x2a, 0x02,
	0x20, 0x5f, 0xbd, 0xdf, 0xc0, 0x02, 0xe3, 0x29, 0x21, 0xdc, 0xc5, 0xbe, 0x9f, 0x12, 0xc6, 0xee,
	0xe9, 0x64, 0x35, 0xaf, 0xc0, 0x3b, 0x1a, 0x3a, 0x48, 0xb8, 0xad, 0x33, 0x58, 0x2f, 0xe1, 0xb6,
	0xc8, 0x6f, 0x9e, 0x50, 0x03, 0x54, 0x7e, 0x13, 0xbf, 0x45, 0x5a, 0x65, 0x5c, 0xbc, 0xac, 0x35,
	0xa5, 0xb4, 0x5c, 0x88, 0x17, 0xf7, 0x97, 0x20, 0x11, 0x0f, 0xa2, 0x4c, 0x3e, 0x55, 0xc7, 0x2c,
	0x05, 0xc6, 0xa3, 0x59, 0xcc, 0xd3, 0x8e, 0x4c, 0x23, 0x55, 0xc7, 0x2c, 0xed, 0x7f, 0x4e, 0x40,
	0xed, 0x30, 0xc5, 0xde, 0x1b, 0xed, 0xe6, 0x3b, 0xb0, 0xc0, 0xc5, 0x72, 0xc0, 0xd1, 0x73, 0xbc,
	0x4b, 0x25, 0x6f, 0xcd, 0x05, 0xcf, 0xcb, 0xc4, 0x85, 0xcf, 0xcb, 0x40, 0x24, 0x95, 0x07, 0x23,
	0x69, 0x0d, 0xa6, 0x53, 0x82, 0x19, 0x8d, 0xf5, 0x93, 0xa2, 0x57, 0x7d, 0x41, 0x32, 0x75, 0xf9,
	0x20, 0x99, 0x1e, 0x27, 0x48, 0xfa, 0xe2, 0x7a, 0x66, 0x9c, 0xb8, 0xb6, 0xff, 0x3b, 0x01, 0x6b,
	0xc7, 0xd4, 0xff, 0x9e, 0xf2, 0xa0, 0x19, 0x78, 0x3a, 0x5b, 0x71, 0x1e, 0xc4, 0x2d, 0x34, 0x0f,
	0x13, 0xb9, 0x7d, 0x27, 0x82, 0x77, 0x3e, 0xbc, 0x0f, 0x7a, 0x6a, 0x04, 0xbb, 0x50, 0x23, 0x9c,
	0x23, 0xb4, 0x50, 0x2d, 0x7c, 0x0d, 0x35, 0x2f, 0x63, 0x9c, 0x46, 0x2e, 0x27, 0x6f, 0xcd, 0xbd,
	0x18, 0xac, 0x6b, 0x0e, 0x78, 0x1a, 0xc4, 0x2d, 0x95, 0x54, 0x41, 0x31, 0x1c, 0x92, 0xb7, 0x5c,
	0x04, 0x0d, 0x89, 0xf1, 0x49, 0x48, 0xd4, 0xdd, 0xa8, 0x38, 0x66, 0x89, 0x3e, 0x85, 0x19, 0x46,
	0x62, 0x3e, 0x9a, 0x1d, 0xa7, 0x05, 0xe9, 0xc0, 0xfd, 0x9e, 0xb9, 0xbc, 0xeb, 0x2a, 0x63, 0xb8,
	0xce, 0xfe, 0x6b, 0x09, 0xea, 0xe7, 0x1b, 0x8a, 0xed, 0xe3, 0x04, 0xdd, 0x87, 0x29, 0x12, 0xe1,
	0x20, 0x94, 0x4e, 0xa8, 0x6d, 0xdf, 0xb8, 0xd8, 0xb6, 0x8e, 0x22, 0x46, 0x3b, 0x30, 0xeb, 0xb5,
	0x71, 0x1c, 0x93, 0xd0, 0x6d, 0x12, 0xe2, 0xeb, 0x44, 0x37, 0x8c, 0xb9, 0xa6, 0x79, 0x9e, 0x13,
	0xe2, 0xdb, 0xff, 0x40, 0x50, 0x3e, 0xa6, 0xbe, 0x28, 0xa4, 0x4f, 0x52, 0x8a, 0x7d, 0x0f, 0x33,
	0x5e, 0xc8, 0xaa, 0x39, 0x4c, 0xba, 0x7f, 0xbe, 0x4b, 0x22, 0x03, 0x61, 0x42, 0x06, 0xc2, 0x42,
	0xb1, 0x58, 0x14, 0x5e, 0x9f, 0xcb, 0xc9, 0xc4, 0x12, 0xbd, 0x82, 0x95, 0x1c, 0x40, 0x52, 0x97,
	0xd1, 0x26, 0x3f, 0xc3, 0x29, 0xd1, 0xa9, 0xf5, 0xe2, 0x38, 0x58, 0x2e, 0x70, 0x1e, 0x68, 0x46,
	0xb4, 0x01, 0x35, 0x8f, 0x46, 0x51, 0x16, 0x07, 0x3c, 0x20, 0xa2, 0x7e, 0x2f, 0x0b, 0x55, 0x0b,
	0xa0, 0x5f, 0x73, 0x3d, 0xbf, 0xec, 0xb2, 0x9e, 0x74, 0x74, 0x58, 0x5d, 0xac, 0xa3, 0x61, 0xde,
	0xed, 0xa0, 0xcf, 0xa1, 0xea, 0x93, 0x90, 0x70, 0x32, 0x5a, 0x68, 0x55, 0x14, 0xf1, 0x0e, 0x47,
	0xf7, 0x61, 0x46, 0xfd, 0xf6, 0xdf, 0x19, 0x56, 0xbb, 0x94, 0x86, 0x6a, 0x43, 0x43, 0x8a, 0x1e,
	0x43, 0xcd, 0x27, 0xcc, 0x4b, 0x83, 0x44, 0x3e, 0x9c, 0xd5, 0x11, 0x94, 0x2d, 0x32, 0xa0, 0x17,
	0xb0, 0x58, 0x58, 0xba, 0x6d, 0x1e, 0x85, 0x32, 0xbd, 0x0f, 0x13, 0xb2, 0x50, 0xe0, 0x7a, 0xc9,
	0xa3, 0xb0, 0xe7, 0xf9, 0xae, 0xf5, 0x3e, 0xdf, 0xe8, 0x8e, 0xea, 0xb2, 0xe6, 0x36, 0xca, 0x9b,
	0xb5, 0xed, 0x95, 0x42, 0xac, 0x6c, 0x3d, 0x4f, 0xd8, 0x33, 0x91, 0xfc, 0x55, 0xef, 0xf5, 0x09,
	0x4c, 0xb6, 0xc4, 0x4b, 0x36, 0x3f, 0x82, 0x02, 0x92, 0x52, 0xa7, 0xad, 0x85, 0x3c, 0x6d, 0x3d,
	0x84, 0x4a, 0x88, 0xe3, 0x56, 0x86, 0x5b, 0x44, 0x17, 0x6e, 0x17, 0x4b, 0xc9, 0xa9, 0x05, 0x67,
	0x84, 0xe3, 0xa0, 0x49, 0x18, 0x97, 0x15, 0xda, 0x50, 0x4e, 0x43, 0x5d, 0x28, 0x68, 0x50, 0x4f,
	0x41, 0x23, 0xda, 0xb8, 0x34, 0x68, 0x05, 0xb1, 0x2e, 0xc7, 0x2e, 0x96, 0xa7, 0x69, 0x45, 0xbf,
	0x40, 0xcf, 0x62, 0x92, 0x8a, 0x1b, 0xb8, 0xa2, 0x1e, 0x48, 0xb9, 0x6e, 0x48, 0x5f, 0x77, 0xdb,
	0x48, 0x66, 0xad, 0x4a, 0x73, 0xae, 0x17, 0xcd, 0xe9, 0x74, 0xd1, 0xca, 0xac, 0x45, 0x06, 0xf4,
	0x12, 0x96, 0x18, 0xcd, 0x52, 0x8f, 0xb8, 0x38, 0xf5, 0xda, 0xc1, 0xa9, 0x7c, 0x20, 0xd7, 0x46,
	0x71, 0xb6, 0x62, 0xdb, 0x51, 0x5c, 0xaa, 0x50, 0x65, 0x1c, 0xa7, 0xe2, 0x86, 0xd0, 0xd8, 0xba,
	0x32, 0xfc, 0x72, 0x69, 0xea, 0x57, 0x31, 0xfa, 0x00, 0xa6, 0x45, 0x89, 0x90, 0x31, 0xcb, 0x92,
	0xa9, 0x63, 0xa9, 0xa0, 0xff, 0x81, 0x44, 0x38, 0x9a, 0x40, 0x98, 0x82, 0xe3, 0x96, 0x2b, 0xfa,
	0x7d, 0xeb, 0xaa, 0xbc, 0xe1, 0x33, 0x1c, 0xb7, 0xbe, 0x13, 0xed, 0xd9, 0xb6, 0x69, 0x00, 0xeb,
	0x23, 0xa8, 0xaf, 0xdb, 0xc3, 0x5b, 0x30, 0xcb, 0x29, 0xc7, 0xa1, 0x29, 0x74, 0xaf, 0x49, 0x6f,
	0xd5, 0x24, 0xac, 0x50, 0xe9, 0x76, 0xb3, 0xfb, 0xfa, 0x38, 0x0f, 0xb3, 0xec, 0x87, 0x03, 0xeb,
	0xba, 0xe9, 0x87, 0x03, 0x74, 0x17, 0x2a, 0xa7, 0x01, 0x39, 0x13, 0xef, 0x94, 0x75, 0x43, 0x9e,
	0x75, 0xb9, 0x70, 0xd6, 0x63, 0x8d, 0x72, 0x72, 0x22, 0xf1, 0xb6, 0x9b, 0xdf, 0x62, 0xfb, 0x9b,
	0xc3, 0xdf, 0x76, 0x43, 0xbe, 0xc3, 0x45, 0x1d, 0x26, 0x56, 0xcc, 0xda, 0x90, 0xc7, 0x52, 0x0b,
	0xf4, 0x35, 0xcc, 0x26, 0xd9, 0x49, 0x18, 0xb0, 0xb6, 0x3a, 0xd2, 0xad, 0xa1, 0x32, 0x6b, 0x39,
	0xfd, 0x0e, 0x47, 0x1f, 0x03, 0x0a, 0x62, 0x2f, 0x25, 0xa2, 0x70, 0x77, 0x85, 0x44, 0x57, 0xf4,
	0xfc, 0xb6, 0x3c, 0xe3, 0x62, 0x8e, 0x11, 0x47, 0x39, 0x4a, 0x43, 0xd1, 0x7f, 0xff, 0x9c, 0xe1,
	0x50, 0xa5, 0xe4, 0xf7, 0xa4, 0xc3, 0xba, 0x00, 0xf4, 0x01, 0x2c, 0x26, 0x29, 0x91, 0x42, 0xb8,
	0x1e, 0x4f, 0x58, 0xb7, 0xa5, 0xa4, 0x05, 0x0d, 0xcf, 0xa7, 0x16, 0x4f, 0x60, 0x96, 0xb5, 0xe9,
	0x99, 0xdb, 0x94, 0x23, 0x21, 0x66, 0xbd, 0x3f, 0x18, 0xe9, 0xdd, 0x89, 0x91, 0x89, 0x74, 0xd6,
	0x85, 0xa0, 0xdf, 0xc1, 0x32, 0x37, 0x33, 0x8b, 0x7c, 0x37, 0x66, 0xdd, 0x91, 0x72, 0xae, 0x1a,
	0x39, 0x03, 0xe3, 0x12, 0x07, 0xf1, 0x7e, 0x10, 0x43, 0x1f, 0xc2, 0x12, 0x23, 0xe4, 0x8d, 0xab,
	0x95, 0x64, 0xd2, 0x04, 0x9b, 0x4a, 0x71, 0x81, 0x78, 0xad, 0xe1, 0xc2, 0x02, 0x9f, 0xc0, 0x0a,
	0x8e, 0x83, 0x48, 0x06, 0x90, 0x39, 0xac, 0x20, 0xff, 0x40, 0xb7, 0x7c, 0x1a, 0xa7, 0x59, 0x04,
	0x87, 0x19, 0xc4, 0x7c, 0x58, 0x18, 0xc4, 0xe8, 0xd1, 0xca, 0x47, 0xf9, 0x68, 0x05, 0xfd, 0x1e,
	0x56, 0xe3, 0xc2, 0x33, 0xce, 0x5c, 0xa6, 0x1e, 0x72, 0xeb, 0x63, 0xe9, 0xcf, 0x21, 0x75, 0x98,
	0x28, 0x2f, 0x9c, 0x95, 0x1e, 0x01, 0xa6, 0xec, 0xfb, 0x16, 0x96, 0xdb, 0x38, 0xf6, 0xcf, 0xf0,
	0x29, 0x71, 0xc5, 0x71, 0x63, 0xaf, 0xe3, 0x46, 0xcc, 0xfa, 0xed, 0x08, 0x2d, 0xb4, 0xe1, 0xfb,
	0x4e, 0xb1, 0xed, 0x33, 0xf4, 0x19, 0xcc, 0x34, 0x71, 0x10, 0x66, 0x29, 0xb1, 0xb6, 0xb4, 0x00,
	0xad, 0xd7, 0x53, 0xf9, 0x3c, 0x3e, 0x4b, 0x53, 0x9a, 0x9a, 0xea, 0xdb, 0x31, 0xb4, 0xf5, 0x07,
	0x50, 0x31, 0xcf, 0x80, 0x38, 0xfa, 0x1b, 0xd2, 0xd1, 0xa5, 0x87, 0xf8, 0x29, 0xe3, 0x5a, 0x6c,
	0x28, 0x2b, 0x8d, 0x92, 0xa3, 0x16, 0x5f, 0x4c, 0x3c, 0x2c, 0xd5, 0x1f, 0xc3, 0x62, 0x7f, 0xbe,
	0x1b, 0xc6, 0x5f, 0x2d, 0xf2, 0x3b, 0xb0, 0xd8, 0x1f, 0x45, 0xe7, 0xf0, 0x6f, 0x16, 0xf9, 0x6b,
	0xdb, 0xc8, 0x1c, 0xa9, 0xcb, 0x5a, 0x90, 0x69, 0x7f, 0x06, 0x2b, 0xea, 0xac, 0x47, 0x49, 0x48,
	0xb1, 0x9f, 0x8f, 0xc0, 0xae, 0x43, 0xf9, 0x94, 0xfa, 0xba, 0xb4, 0xab, 0x15, 0xdc, 0xe5, 0x08,
	0xb8, 0xfd, 0x00, 0x56, 0x15, 0x9b, 0x4e, 0xb1, 0xa3, 0xf2, 0x7d, 0x03, 0x37, 0xe5, 0x38, 0x32,
	0xc6, 0xa1, 0xe2, 0x7f, 0x19, 0xb4, 0xda, 0x61, 0xd0, 0x6a, 0xf3, 0x51, 0x25, 0x3c, 0x81, 0x1b,
	0xfb, 0x38, 0xc6, 0x2d, 0x92, 0x5e, 0x52, 0xc0, 0x23, 0xb0, 0x5e, 0x8b, 0x8c, 0xe1, 0xbd, 0x20,
	0xfc, 0x98, 0xfa, 0xbb, 0x9d, 0xc6, 0xde, 0xa8, 0xac, 0x5f, 0x42, 0xdd, 0x68, 0x3f, 0x3e, 0xf3,
	0x2e, 0xdc, 0xd2, 0x8a, 0x5f, 0x5e, 0xc6, 0xdf, 0x27, 0x61, 0x59, 0x8f, 0x27, 0x1a, 0x71, 0x93,
	0xe6, 0x6c, 0xfd, 0xcd, 0xd0, 0x21, 0x5c, 0x39, 0xbf, 0xc3, 0x64, 0xd6, 0x44, 0x6f, 0x6a, 0x3a,
	0x6f, 0xfe, 0xe9, 0xac, 0x9e, 0xd7, 0x7d, 0x32, 0xf4, 0x18, 0xe6, 0xd5, 0x50, 0x85, 0xa9, 0xc9,
	0x08, 0xb3, 0xca, 0x52, 0xd8, 0x95, 0x82, 0x9e, 0xc5, 0xc9, 0x89, 0x33, 0x17, 0x15, 0x56, 0xa2,
	0x5a, 0x82, 0x6e, 0xf3, 0xaa, 0x5b, 0xaa, 0xe2, 0x6b, 0xaa, 0x3a, 0x58, 0xa7, 0x9a, 0x37, 0xb3,
	0xe8, 0x21, 0xcc, 0x15, 0x3b, 0x6a, 0x66, 0x4d, 0xc9, 0x0d, 0xf3, 0x67, 0xa9, 0xd0, 0x7d, 0x3b,
	0xb3, 0x85, 0x26, 0x5b, 0x5c, 0x6d, 0x39, 0xc5, 0x14, 0xfb, 0xbf, 0xb3, 0xcf, 0x2a, 0x54, 0xa7,
	0x01, 0x93, 0x8a, 0xa3, 0xe7, 0xb0, 0xe4, 0xe1, 0xd8, 0x55, 0xd5, 0xb1, 0xd1, 0x74, 0x66, 0x28,
	0xff, 0x82, 0x87, 0x63, 0x7d, 0x1f, 0x94, 0xe2, 0x7b, 0xb0, 0x28, 0x73, 0x29, 0x8d, 0xc3, 0x8e,
	0x11, 0x33, 0xbc, 0x48, 0x9e, 0x17, 0x3c, 0xaf, 0xe2, 0xb0, 0xa3, 0xa5, 0xbc, 0x04, 0xd4, 0xc6,
	0xcc, 0x4d, 0x48, 0xec, 0x07, 0x71, 0xcb, 0xc8, 0xa9, 0x0e, 0x95, 0xb3, 0xd8, 0xc6, 0xec, 0xb5,
	0x62, 0x52, 0x92, 0xec, 0x1f, 0xe1, 0xba, 0x0e, 0x3e, 0x15, 0x74, 0x03, 0x11, 0xf4, 0x10, 0xaa,
	0x72, 0x9a, 0x18, 0xc4, 0x4d, 0xaa, 0xc3, 0xef, 0x5a, 0x9f, 0x5b, 0x8b, 0xf4, 0x4e, 0x25, 0xd2,
	0x10, 0xfb, 0x27, 0xb8, 0xd1, 0x1b, 0xd0, 0xff, 0x47, 0xd9, 0x7f, 0xcc, 0x2f, 0x7b, 0xaf, 0x68,
	0x96, 0xcb, 0xfe, 0x02, 0x20, 0x97, 0xcd, 0xac, 0x92, 0x0c, 0x8f, 0x0b, 0x85, 0x57, 0x8d, 0x70,
	0x66, 0x3f, 0x83, 0xdb, 0xdd, 0x2b, 0xd8, 0x88, 0xbd, 0x30, 0xf3, 0xc9, 0xae, 0x68, 0x33, 0xfd,
	0x23, 0x46, 0x52, 0x36, 0xea, 0xa5, 0xfc, 0x02, 0xae, 0xf6, 0x28, 0x39, 0xce, 0x85, 0xfe, 0x2a,
	0xe7, 0x3d, 0x20, 0xa2, 0xc6, 0x3d, 0xa6, 0x7e, 0x77, 0xdf, 0x9b, 0x30, 0x79, 0x4a, 0x7d, 0x73,
	0xaa, 0x1e, 0x66, 0x89, 0xb0, 0x1f, 0xc3, 0xb5, 0x62, 0x2a, 0x63, 0xbb, 0x1d, 0xa1, 0xf8, 0xe8,
	0xfc, 0x2f, 0xe0, 0xf6, 0xb9, 0x29, 0x69, 0x6c, 0x41, 0x3f, 0xc0, 0x56, 0x8f, 0x09, 0xb4, 0x80,
	0x0b, 0x6c, 0x3a, 0x54, 0xe4, 0x4b, 0x78, 0x7f, 0x40, 0xa9, 0xdd, 0xbc, 0xb3, 0xdf, 0x1b, 0x43,
	0xd2, 0xd7, 0x50, 0xef, 0xb3, 0xd2, 0x58, 0xec, 0x4f, 0x60, 0x7d, 0x40, 0x91, 0xb1, 0x04, 0x34,
	0xe0, 0x4e, 0x91, 0xf1, 0xd7, 0x18, 0xe5, 0x09, 0xac, 0x9f, 0xe3, 0xf0, 0x31, 0x04, 0x7c, 0x06,
	0xe8, 0x05, 0xe1, 0x87, 0x34, 0x19, 0x2f, 0xd0, 0x1e, 0x81, 0xa5, 0xfd, 0x7b, 0x24, 0xfb, 0x07,
	0x81, 0x19, 0x31, 0xc2, 0x3f, 0x87, 0x95, 0xa3, 0x58, 0x35, 0xff, 0xe3, 0xee, 0xb9, 0x76, 0x40,
	0x9b, 0x7c, 0xef, 0x12, 0xac, 0x4f, 0x61, 0xc3, 0xb8, 0x4c, 0x6a, 0x1a, 0x51, 0x51, 0xa1, 0x78,
	0x34, 0x1d, 0x73, 0xff, 0x97, 0x38, 0xf5, 0x2f, 0xb3, 0xbf, 0x0d, 0x1b, 0xbd, 0xaa, 0x37, 0x62,
	0xf3, 0x11, 0xd6, 0x08, 0xb1, 0xbf, 0xc9, 0x33, 0xf2, 0x65, 0x4f, 0x79, 0x05, 0x56, 0x7f, 0xa4,
	0x19, 0xcf, 0x4e, 0xc8, 0xb3, 0xb7, 0x09, 0x4d, 0xf3, 0x02, 0xc8, 0xb6, 0x60, 0xed, 0x79, 0x10,
	0xe3, 0x30, 0xf8, 0xa5, 0xaf, 0xaa, 0x13, 0x18, 0xe5, 0xc0, 0x7d, 0x3d, 0x0b, 0xc8, 0x31, 0x57,
	0x60, 0xf5, 0x80, 0xc8, 0xc6, 0x48, 0x4e, 0xb7, 0x73, 0x35, 0xec, 0x10, 0x6c, 0x15, 0x72, 0xe2,
	0x81, 0x6e, 0xb5, 0x52, 0xd2, 0x52, 0x05, 0x79, 0xff, 0x25, 0x50, 0x6d, 0xa9, 0x2b, 0xb9, 0xf5,
	0x87, 0x12, 0x90, 0xa0, 0xa7, 0x02, 0x82, 0xde, 0x87, 0x79, 0x45, 0xd0, 0xf7, 0xc9, 0x64, 0x4e,
	0x42, 0xcd, 0xa7, 0x28, 0xfb, 0x1e, 0xac, 0x1e, 0x53, 0xff, 0x35, 0x4d, 0xb2, 0x10, 0xa7, 0x01,
	0xef, 0xe4, 0x1b, 0x58, 0x30, 0x93, 0x28, 0xa8, 0x14, 0x5e, 0x71, 0xcc, 0xd2, 0xfe, 0x5b, 0x09,
	0x96, 0xcf, 0x29, 0xd7, 0x0b, 0x03, 0xe1, 0x52, 0x71, 0x20, 0x7c, 0x1d, 0x80, 0x08, 0x3a, 0x57,
	0xce, 0xfa, 0x55, 0x8d, 0x5d, 0x95, 0x90, 0xa7, 0xd4, 0x27, 0xe8, 0x3d, 0x98, 0x53, 0xe8, 0x88,
	0x30, 0x86, 0x5b, 0xe6, 0x83, 0xed, 0xac, 0x04, 0xee, 0x2b, 0x58, 0xdf, 0xa8, 0x6e, 0x72, 0x8c,
	0x51, 0x9d, 0xbd, 0x0f, 0x96, 0x52, 0x36, 0xef, 0xe5, 0xba, 0x46, 0xbc, 0x07, 0x90, 0xb7, 0x73,
	0xc6, 0xef, 0x4b, 0x03, 0xbd, 0x9f, 0x53, 0x20, 0xb2, 0xff, 0x00, 0x1f, 0x2a, 0x71, 0x4f, 0xd5,
	0xec, 0xd9, 0x60, 0x8c, 0xdf, 0x7f, 0xce, 0x0a, 0x4e, 0x36, 0x7d, 0x5a, 0xa9, 0xdb, 0xa7, 0x5d,
	0x83, 0x6a, 0x26, 0x49, 0xbb, 0x83, 0xf3, 0x8a, 0x02, 0x34, 0x7c, 0xfb, 0x16, 0xdc, 0xd4, 0x21,
	0xaa, 0xc2, 0x73, 0x50, 0x65, 0xbb, 0x0e, 0xd6, 0x3b, 0x71, 0xff, 0x29, 0xc3, 0x55, 0x91, 0x9e,
	0x84, 0x43, 0x53, 0x9a, 0x90, 0x54, 0x74, 0xd5, 0x85, 0xb4, 0x01, 0x66, 0x0e, 0x9c, 0xbb, 0xa8,
	0xaa, 0x21, 0x0d, 0x5f, 0x36, 0xb1, 0xa2, 0xc7, 0x13, 0x91, 0x2e, 0xda, 0x6a, 0x72, 0x4a, 0x52,
	0xa9, 0x60, 0xc5, 0x59, 0x10, 0x08, 0x71, 0x55, 0x9e, 0x2b, 0x30, 0xda, 0x84, 0x45, 0xe1, 0x69,
	0xc6, 0x69, 0x8a, 0x5b, 0xc4, 0xf5, 0x71, 0x87, 0xe9, 0xbf, 0x4d, 0xcc, 0x9f, 0x52, 0xff, 0x40,
	0x81, 0xf7, 0x70, 0x87, 0xa1, 0xdb, 0x30, 0x2f, 0xca, 0x3b, 0x7d, 0x64, 0x91, 0xb6, 0x26, 0xa5,
	0xc8, 0x59, 0x0f, 0xc7, 0xca, 0x64, 0xc7, 0xd4, 0x47, 0x5f, 0x41, 0xbd, 0xa3, 0x2e, 0x96, 0x4b,
	0xe4, 0xcd, 0x12, 0xc5, 0x97, 0x1f, 0xb0, 0xe2, 0x3c, 0xdf, 0xea, 0x14, 0xaf, 0x5e, 0x10, 0xb7,
	0xf6, 0x34, 0x1e, 0xdd, 0x87, 0x35, 0xf6, 0x26, 0x48, 0xcc, 0x26, 0x11, 0xf5, 0x89, 0x8e, 0x78,
	0xf5, 0x31, 0x6c, 0x45, 0x60, 0xd5, 0x66, 0xfb, 0x39, 0x4e, 0x7e, 0xd3, 0x14, 0x5c, 0x51, 0x26,
	0xdb, 0xe4, 0x19, 0x49, 0x0a, 0x02, 0xb4, 0x2f, 0x21, 0xa2, 0x53, 0x2f, 0xa8, 0x9e, 0xc5, 0x61,
	0x10, 0x05, 0x66, 0xf4, 0x5a, 0x71, 0x50, 0x7e, 0x80, 0x23, 0x83, 0xe9, 0x8b, 0xd2, 0xea, 0xe5,
	0x3f, 0x1a, 0xc0, 0x38, 0x1f, 0x0d, 0xfe, 0x32, 0x01, 0xb6, 0xf4, 0x7a, 0xe0, 0x13, 0xfa, 0x3a,
	0x0d, 0x4e, 0xb1, 0xd7, 0x19, 0xdf, 0xfd, 0xef, 0xc1, 0x5c, 0x3b, 0xf0, 0xf3, 0xb9, 0x1f, 0xd3,
	0xae, 0x9f, 0x15, 0x40, 0xdd, 0x72, 0x32, 0xb4, 0x0d, 0xab, 0x3d, 0x44, 0xae, 0xf9, 0xe4, 0x52,
	0x96, 0xc4, 0xcb, 0x45, 0xe2, 0x67, 0xfa, 0xf3, 0xcb, 0xe5, 0xaf, 0x6e, 0x9f, 0x51, 0xa6, 0xc6,
	0x31, 0x4a, 0xdd, 0xdc, 0xfa, 0xbc, 0xcb, 0xe9, 0x5e, 0x93, 0x13, 0x40, 0x83, 0xd0, 0xe1, 0x09,
	0xf5, 0x23, 0x98, 0x31, 0x4d, 0xd1, 0x44, 0x6f, 0xa6, 0xe8, 0x76, 0x52, 0x86, 0xc2, 0x5e, 0x87,
	0xba, 0xa3, 0xbe, 0xaa, 0x15, 0x3b, 0xa6, 0xc2, 0x25, 0xd6, 0xd8, 0x2e, 0xab, 0xc1, 0x65, 0x70,
	0xfd, 0xbc, 0x16, 0xb1, 0xab, 0xe8, 0x05, 0xad, 0x66, 0xe9, 0xd2, 0xad, 0xe6, 0x6e, 0xe5, 0x27,
	0xfd, 0xe7, 0xad, 0x93, 0x69, 0x69, 0xd9, 0x4f, 0xff, 0x17, 0x00, 0x00, 0xff, 0xff, 0x6d, 0x2a,
	0x4c, 0x7d, 0xde, 0x25, 0x00, 0x00,
}
