package external_integrations

// NOTE: We're using a subset of all available fields here. Copypasta's beware!

// TestRecord is an approximation of a Record, with fields conforming to what Visage uses.
type TestRecord struct {
	RecordID  string `json:"record_id"`
	ChannelID string `json:"channel_id"`
	Data      string `json:"data,omitempty"`
}

// TestRecordUpdate is an approximation of a CollectionItemUpdate
type TestRecordUpdate struct {
	RecordID  string  `json:"record_id"`
	ChannelID *string `json:"channel_id"`
	Data      *string `json:"data,omitempty"`
}

// TestRecordsResult is an approximation of RecordsResult.
type TestRecordsResult struct {
	Records           []*TestRecord `json:"records"`
	EncodedNextCursor *string       `json:"next_cursor,omitempty"`
}

var (
	ChannelID           = "155393848"
	ChannelIDProduction = "157237187"

	testRecord1 = TestRecord{
		RecordID:  "record1",
		ChannelID: ChannelID,
		Data:      "data1",
	}

	testRecord2 = TestRecord{
		RecordID:  "record2",
		ChannelID: ChannelID,
		Data:      "data2",
	}

	testRecord1Production = TestRecord{
		RecordID:  "record1",
		ChannelID: ChannelIDProduction,
		Data:      "data1",
	}

	testRecord2Production = TestRecord{
		RecordID:  "record2",
		ChannelID: ChannelIDProduction,
		Data:      "data2",
	}

	newData = "newData1"

	testRecordUpdate = TestRecordUpdate{
		RecordID: "record1",
		Data:     &newData,
	}

	testRecordUpdateProduction = TestRecordUpdate{
		RecordID: "record1",
		Data:     &newData,
	}

	testEncodedNextCursor = "next"

	testRecordsResult = TestRecordsResult{
		Records: []*TestRecord{
			&testRecord1,
			&testRecord2,
		},
		EncodedNextCursor: &testEncodedNextCursor,
	}

	testRecordsResultProduction = TestRecordsResult{
		Records: []*TestRecord{
			&testRecord1Production,
			&testRecord2Production,
		},
		EncodedNextCursor: &testEncodedNextCursor,
	}
)
