package external_integrations

import (
	"fmt"
	"log"
	"os"
	"testing"
	"time"
)

// testvodapiEndpoints is an integration test for records.
func testvodapiEndpoints(t *testing.T, settings *Settings) {
	host := os.Getenv("HOST")
	if host == "" {
		host = settings.VisageHost
	}

	log.Println("vodapi Tests")
	log.Println("Using visage host:", host)

	c, err := newClient(host, settings.OAuthToken, settings.TestUserID)
	if err != nil {
		fmt.Printf("Unable to instantiate client: %s", err)
		t.Fatal()
	}

	// Purge records to avoid collisions with previous integration runs
	err = teardown(settings)
	if err != nil {
		fmt.Printf("Unable to connect to dynamo to remove records before test start: %s", err)
		t.Fatal()
	}

	// Wait just 1 second
	time.Sleep(1 * time.Second)

	data := settings.Data

	// Create records.
	record, err := c.CreateRecord(data.Record1)
	if err != nil {
		fmt.Printf("Error creating record 1: %s", err)
		t.Fatal()
	}
	if !recordEquals(*record, data.Record1) {
		fmt.Printf("record: %+v\n", *record)
		fmt.Printf("Record does not match")
		t.Fatal()
	}

	record, err = c.CreateRecord(data.Record2)
	if err != nil {
		fmt.Printf("Error creating record 2: %s", err)
		t.Fatal()
	}
	if !recordEquals(*record, data.Record2) {
		fmt.Printf("record: %+v\n", *record)
		fmt.Printf("Record does not match")
		t.Fatal()
	}

	// Bulk get.
	recordsResult, err := c.GetRecords()
	if err != nil {
		fmt.Printf("Error getting records: %s", err)
		t.Fatal()
	}
	if !recordsResultsEquals(*recordsResult, data.RecordsResult) {
		fmt.Printf("recordsResult: %+v\n", recordsResult)
		fmt.Printf("RecordsResult does not match")
		t.Fatal()
	}

	// Update record1.
	err = c.UpdateRecord(data.RecordUpdate)
	if err != nil {
		fmt.Printf("Error updating record: %s", err)
		t.Fatal()
	}

	record, err = c.GetRecord(data.Record1.RecordID)
	if err != nil {
		fmt.Printf("Error getting record: %s", err)
		t.Fatal()
	}
	if record.Data != *data.RecordUpdate.Data {
		fmt.Printf("Updated data incorrect: %s", record.Data)
		t.Fatal()
	}

	// Delete both records.
	err = c.DeleteRecord(data.Record1.RecordID)
	if err != nil {
		fmt.Printf("Error deleting record1: %s", err)
		t.Fatal()
	}

	err = c.DeleteRecord(data.Record2.RecordID)
	if err != nil {
		fmt.Printf("Error deleting record2: %s", err)
		t.Fatal()
	}
}
