package integrations

const (
	production = "production"
	local      = "local"
)

// Settings is the list of settings specific to the environment.
type Settings struct {
	OAuthToken string
	TestUserID string
	Host       string
}

// getSettings gets the environment specific settings.
func getSettings(environment string) *Settings {
	// As of May 1st 2017, oauth tokens don't expire, so instead of doing messy programmatic
	// 3rd party token granting, we're just going to hardcode the oauth token until the
	// process is simpler.
	if environment == production {
		return &Settings{
			OAuthToken: "r4o7fwp1tjesfme2dpz5bw9qyvfjem",
			TestUserID: "241122822",
			Host:       "http://vodapi-production-twitch.us-west-2.elasticbeanstalk.com",
		}
	}
	if environment == local {
		return &Settings{
			OAuthToken: "r4o7fwp1tjesfme2dpz5bw9qyvfjem",
			TestUserID: "241122822",
			Host:       "http://localhost:8000",
		}
	}
	return &Settings{
		OAuthToken: "r4o7fwp1tjesfme2dpz5bw9qyvfjem",
		TestUserID: "241122822",
		Host:       "http://vodapi-staging-twitch.us-west-2.elasticbeanstalk.com",
	}
}
