Discovery
========

[![GoDoc](://godoc.internal.justin.tv/code.justin.tv/web/discovery?status.png)](http://godoc.internal.justin.tv/code.justin.tv/web/discovery)

Discovery is a service that allows you to get useful information about games and streams' game information. Most importantly, it powers the game selector and the "All Games" page on the directory.

## API

Production: [http://discovery-production.prod.us-west2.twitch.tv](http://discovery-production.prod.us-west2.twitch.tv)  
Staging: [http://discovery-staging.dev.us-west2.twitch.tv](http://discovery-staging.dev.us-west2.twitch.tv)  

[api.md](docs/api.md)

Development
-----------

First, install Go

    brew install go --cross-compile-common

Now set up your $GOPATH

    mkdir $HOME/go
    export GOPATH=$HOME/go

Download the repo into it

    go get -d code.justin.tv/web/discovery
    cd ~/go/src/code.justin.tv/web/discovery

Install Foreman

    gem install foreman

And run!

    make run

To run the indexer/jaxstore jobs:

    foreman start jaxstore
    foreman start index_all
    foreman start index_popularity

### Dev Tools

Formatting:

    go fmt ./...

Check for more subtle errors:

    go vet ./...

Tests:

    make test

You can also use [goconvey](http://goconvey.co) for much more pleasant testing:

    goconvey -port=2020

Updating dependencies (note: change/add package in glide.yaml for this to have an effect):

    make upgrade


Architecture
============

**Codebase:** https://git-aws.internal.justin.tv/web/discovery <br>
**Summary:** Service to get game information <br>
**Purpose:** Powers game selector and "All Games" page on directory <br>

<img src="docs/resources/Discovery-Algorithm.png" alt="Discovery Algorithm" width="800"/>
<img src="docs/resources/Discovery-Resources.png" alt="Discovery Resources" width="800"/>
