package bininfo

import (
	"expvar"

	"code.justin.tv/common/golibs/pkgpath"
)

type procInfo struct {
	Revision string `json:"revision"`
	SvcName  string `json:"svcname"`
}

func export() interface{} {
	return &procInfo{
		Revision: revision,
		SvcName:  svcname,
	}
}

// init Responsible for publishing procInfo into expvar
func init() {
	name, ok := pkgpath.Caller(0)
	if !ok {
		return
	}
	expvar.Publish(name, expvar.Func(func() interface{} { return export() }))
}
