package api

import (
	"fmt"
	"net/http"

	"code.justin.tv/common/chitin"
	"code.justin.tv/web/discovery/backend"
	"github.com/jixwanwang/apiutils"
)

func (T *API) addAlias(w http.ResponseWriter, r *http.Request) {
	ctx := chitin.Context(w, r)

	err := apiutils.RequireFormParams(r, []string{"alias"})
	if err != nil {
		T.serveError(w, r, apiutils.NewErrorResponse(http.StatusBadRequest, err.Error()))
		return
	}

	g, err := T.getGame(ctx, w, r)
	if err != nil {
		return
	}

	if g.Name == r.FormValue("alias") {
		T.serveError(w, r, apiutils.NewErrorResponse(http.StatusBadRequest, "Cannot alias game to itself"))
		return
	}

	err = T.Backend.AddAlias(ctx, g.ID, r.FormValue("alias"))

	if err != nil {
		T.serveError(w, r, apiutils.NewErrorResponse(http.StatusInternalServerError, err.Error()))
		return
	}

	conflicting, err := T.Backend.GameByName(ctx, r.FormValue("alias"))
	if err == nil {
		T.Backend.DeleteGame(ctx, conflicting)
	}

	apiutils.ServeJSON(w, map[string]string{
		"name":         r.FormValue("name"),
		"alias":        r.FormValue("alias"),
		"game_deleted": fmt.Sprintf("%v", err != backend.ErrGameNotFound),
	})
}
