package api

import (
	"net/http"

	"code.justin.tv/common/chitin"
	"github.com/jixwanwang/apiutils"
)

func (T *API) addLocalization(w http.ResponseWriter, r *http.Request) {

	ctx := chitin.Context(w, r)

	err := apiutils.RequireFormParams(r, []string{"localized_name", "locale"})
	if err != nil {
		T.serveError(w, r, apiutils.NewErrorResponse(http.StatusBadRequest, err.Error()))
		return
	}

	localizedName := r.FormValue("localized_name")
	locale := r.FormValue("locale")

	validLocale, errResponse := validateLocale(locale)
	if errResponse != nil {
		T.serveError(w, r, *errResponse)
		return
	}

	gameID, errResponse := T.getGameIDFromParams(ctx, r.Form)
	if errResponse != nil {
		T.serveError(w, r, *errResponse)
		return
	}

	localization, err := T.Backend.UpsertLocalization(ctx, gameID, localizedName, validLocale)
	if err != nil {
		T.serveError(w, r, apiutils.NewErrorResponse(http.StatusInternalServerError, err.Error()))
		return
	}

	apiutils.ServeJSON(w, localization)
}
