package api

import (
	"net/http"

	"code.justin.tv/common/chitin"
	"github.com/jixwanwang/apiutils"
)

func (T *API) deleteGame(w http.ResponseWriter, r *http.Request) {

	ctx := chitin.Context(w, r)

	g, err := T.getGame(ctx, w, r)

	if err == nil {
		err = T.Backend.DeleteGame(ctx, g.Game)

		if err != nil {
			T.serveError(w, r, apiutils.NewErrorResponse(http.StatusInternalServerError, err.Error()))
			return
		}

		err = T.Backend.DeleteLocalizations(ctx, g.ID)
		if err != nil {
			T.serveError(w, r, apiutils.NewErrorResponse(http.StatusInternalServerError, err.Error()))
			return
		}

		w.WriteHeader(http.StatusNoContent)
	}
}
