package api

import (
	"net/http"

	"code.justin.tv/common/chitin"
	"github.com/jixwanwang/apiutils"
)

func (T *API) deleteLocalization(w http.ResponseWriter, r *http.Request) {
	ctx := chitin.Context(w, r)
	params := r.URL.Query()

	gameID, errResponse := T.getGameIDFromParams(ctx, params)
	if errResponse != nil {
		T.serveError(w, r, *errResponse)
		return
	}

	if len(params["locale"]) <= 0 {
		T.serveError(w, r, apiutils.NewErrorResponse(http.StatusBadRequest, "Missing param: locale"))
		return
	}

	locale := params.Get("locale")

	validLocale, errResponse := validateLocale(locale)
	if errResponse != nil {
		T.serveError(w, r, *errResponse)
		return
	}

	err := T.Backend.DeleteLocalization(ctx, gameID, validLocale)
	if err != nil {
		T.serveError(w, r, apiutils.NewErrorResponse(http.StatusInternalServerError, err.Error()))
		return
	}

	w.WriteHeader(http.StatusNoContent)
}

func (T *API) deleteLocalizations(w http.ResponseWriter, r *http.Request) {
	ctx := chitin.Context(w, r)
	params := r.URL.Query()

	gameID, errResponse := T.getGameIDFromParams(ctx, params)
	if errResponse != nil {
		T.serveError(w, r, *errResponse)
		return
	}

	err := T.Backend.DeleteLocalizations(ctx, gameID)
	if err != nil {
		T.serveError(w, r, apiutils.NewErrorResponse(http.StatusInternalServerError, err.Error()))
		return
	}

	w.WriteHeader(http.StatusNoContent)
}
