package api

import (
	"net/http"
	"net/http/httptest"
	"net/url"
	"strconv"
	"testing"

	"code.justin.tv/web/discovery/backend/backendtest"
	. "github.com/smartystreets/goconvey/convey"
)

func performDeleteLocalizationRequest(params url.Values) *httptest.ResponseRecorder {
	be := backendtest.NewBackend()
	router := API{Backend: be}

	r, _ := http.NewRequest("DELETE", baseURL, nil)
	r.URL.RawQuery = params.Encode()

	return makeTestRequestWithContext(router.deleteLocalization, r)
}

func performDeleteLocalizationsRequest(params url.Values) *httptest.ResponseRecorder {
	be := backendtest.NewBackend()
	router := API{Backend: be}

	r, _ := http.NewRequest("DELETE", baseURL, nil)
	r.URL.RawQuery = params.Encode()

	return makeTestRequestWithContext(router.deleteLocalizations, r)
}

func TestDeleteLocalizaton(t *testing.T) {
	Convey("should require locale to be set", t, func() {
		params := url.Values{
			"game_id": []string{strconv.Itoa(backendtest.TestID)},
		}
		w := performDeleteLocalizationRequest(params)

		So(w.Code, ShouldEqual, http.StatusBadRequest)
		So(w.Body.String(), ShouldContainSubstring, "Missing param: locale")
	})

	Convey("should return a 204 for valid game_id", t, func() {
		params := url.Values{
			"game_id": []string{strconv.Itoa(backendtest.TestID)},
			"locale":  []string{backendtest.TestLocale},
		}
		w := performDeleteLocalizationRequest(params)

		So(w.Code, ShouldEqual, http.StatusNoContent)
	})

	Convey("should return a 204 for valid game_name", t, func() {
		params := url.Values{
			"game_name": []string{backendtest.TestTerm},
			"locale":    []string{backendtest.TestLocale},
		}
		w := performDeleteLocalizationRequest(params)

		So(w.Code, ShouldEqual, http.StatusNoContent)
	})
}

func TestDeleteLocalizatons(t *testing.T) {
	Convey("should return a 204 for valid game_id", t, func() {
		params := url.Values{
			"game_id": []string{strconv.Itoa(backendtest.TestID)},
		}
		w := performDeleteLocalizationsRequest(params)

		So(w.Code, ShouldEqual, http.StatusNoContent)
	})

	Convey("should return a 204 for valid game_name", t, func() {
		params := url.Values{
			"game_name": []string{backendtest.TestTerm},
		}
		w := performDeleteLocalizationsRequest(params)

		So(w.Code, ShouldEqual, http.StatusNoContent)
	})
}
