package api

import (
	"fmt"
	"net/http"

	"code.justin.tv/common/chitin"
	"github.com/jixwanwang/apiutils"
)

func (T *API) game(w http.ResponseWriter, r *http.Request) {
	ctx := chitin.Context(w, r)

	g, err := T.getGame(ctx, w, r)

	if err == nil {
		w.Header().Add("Cache-Control", fmt.Sprintf("public, max-age=%v", defaultMaxCacheAge))
		apiutils.ServeJSON(w, g)
	}
}
