package api

import (
	"golang.org/x/net/context"
	"testing"

	"code.justin.tv/web/discovery/backend/backendtest"
	"code.justin.tv/web/discovery/game"
	. "github.com/smartystreets/goconvey/convey"
)

func TestGameHelper(t *testing.T) {
	Convey("should return game name as localized name", t, func() {
		be := backendtest.NewBackend()
		router := API{Backend: be}

		g, err := router.localizeGames(context.Background(), []game.Game{backendtest.TestGame(backendtest.TestID)}, backendtest.TestEmptyLocale)

		So(err, ShouldBeNil)
		So(len(g), ShouldEqual, 1)
		So(g[0].Game, ShouldResemble, backendtest.TestGame(backendtest.TestID))
		So(g[0].Locale, ShouldEqual, backendtest.TestEmptyLocale)
		So(g[0].LocalizedName, ShouldEqual, backendtest.TestTerm)
	})

	Convey("shouldn't fail on empty game list", t, func() {
		be := backendtest.NewBackend()
		router := API{Backend: be}

		g, err := router.localizeGames(context.Background(), []game.Game{}, backendtest.TestEmptyLocale)

		So(err, ShouldBeNil)
		So(len(g), ShouldEqual, 0)
	})

	Convey("should return game and localized name", t, func() {
		be := backendtest.NewBackend()
		router := API{Backend: be}

		g, err := router.localizeGames(context.Background(), []game.Game{backendtest.TestGame(backendtest.TestID)}, backendtest.TestLocale)

		So(err, ShouldBeNil)
		So(len(g), ShouldEqual, 1)
		So(g[0].Game, ShouldResemble, backendtest.TestGame(backendtest.TestID))
		So(g[0].Locale, ShouldEqual, backendtest.TestLocale)
		So(g[0].LocalizedName, ShouldEqual, backendtest.TestLocalizedName)
	})
}
