package api

import (
	"fmt"
	"net/http"
	"unicode/utf8"

	"code.justin.tv/common/chitin"
	"github.com/jixwanwang/apiutils"
)

func (T *API) gameSuggest(w http.ResponseWriter, r *http.Request) {
	ctx := chitin.Context(w, r)

	params := r.URL.Query()
	locale := params.Get("locale")
	validLocale, errResponse := validateLocale(locale)
	if errResponse != nil {
		T.serveError(w, r, *errResponse)
		return
	}

	err := apiutils.RequireParams(params, []string{"term"})
	if err != nil {
		T.serveError(w, r, apiutils.NewErrorResponse(http.StatusBadRequest, err.Error()))
		return
	}

	term := params.Get("term")
	if !utf8.ValidString(term) {
		T.serveError(w, r, apiutils.NewErrorResponse(http.StatusBadRequest, fmt.Sprintf("Non-UTF8 term: %s", term)))
		return
	}

	games, err := T.Backend.GameSuggest(ctx, term, params.Get("live") == "true")
	if err != nil {
		T.serveError(w, r, apiutils.NewErrorResponse(http.StatusInternalServerError, err.Error()))
		return
	}

	localizedGames, err := T.localizeGames(ctx, games, validLocale)
	if err != nil {
		T.serveError(w, r, apiutils.NewErrorResponse(http.StatusInternalServerError, err.Error()))
		return
	}

	apiutils.ServeJSON(w, localizedGames)
}
