package api

import (
	"fmt"
	"net/http"

	"code.justin.tv/common/chitin"
	"github.com/jixwanwang/apiutils"
)

type aliasesResponse struct {
	Aliases []string `json:"aliases"`
}

func (T *API) getAllAliases(w http.ResponseWriter, r *http.Request) {
	ctx := chitin.Context(w, r)

	g, err := T.getGame(ctx, w, r)
	if err != nil {
		return
	}

	aliases, err := T.Backend.AliasesByGameID(ctx, g.ID)
	if err != nil {
		T.serveError(w, r, apiutils.NewErrorResponse(http.StatusInternalServerError, err.Error()))
		return
	}

	w.Header().Add("Cache-Control", fmt.Sprintf("public, max-age=%v", defaultMaxCacheAge))
	apiutils.ServeJSON(w, aliasesResponse{Aliases: aliases})
}
