package api

import (
	"fmt"
	"net/http"

	"code.justin.tv/common/chitin"
	"code.justin.tv/web/discovery/backend"
	"code.justin.tv/web/discovery/game"
	"github.com/jixwanwang/apiutils"
)

func (T *API) getLocalizations(w http.ResponseWriter, r *http.Request) {
	ctx := chitin.Context(w, r)
	params := r.URL.Query()

	gameID, errResponse := T.getGameIDFromParams(ctx, params)
	if errResponse != nil {
		T.serveError(w, r, *errResponse)
		return
	}

	if len(params.Get("locale")) > 0 {
		locale := params.Get("locale")

		validLocale, errResponse := validateLocale(locale)
		if errResponse != nil {
			T.serveError(w, r, *errResponse)
			return
		}

		localization, err := T.Backend.GetLocalization(ctx, gameID, validLocale)
		T.serveLocalizations(w, r, localization, err)
		return
	}

	localizations, err := T.Backend.GetLocalizations(ctx, gameID)
	T.serveLocalizations(w, r, localizations, err)
}

func (T *API) serveLocalizations(w http.ResponseWriter, r *http.Request, localizations game.Localizations, err error) {
	if err != nil {
		if err == backend.ErrLocalizationNotFound {
			T.serveError(w, r, apiutils.NewErrorResponse(http.StatusNotFound, err.Error()))
			return
		}
		T.serveError(w, r, apiutils.NewErrorResponse(http.StatusInternalServerError, err.Error()))
		return
	}
	w.Header().Add("Cache-Control", fmt.Sprintf("public, max-age=%v", defaultMaxCacheAge))
	apiutils.ServeJSON(w, localizations)
}
