package api

import (
	"encoding/json"
	"fmt"
	"net/http"
	"net/http/httptest"
	"net/url"
	"strconv"
	"testing"

	"code.justin.tv/web/discovery/backend/backendtest"
	"code.justin.tv/web/discovery/game"
	. "github.com/smartystreets/goconvey/convey"
)

func performGetLocalizationsRequest(params url.Values) *httptest.ResponseRecorder {
	be := backendtest.NewBackend()
	router := API{Backend: be}

	r, _ := http.NewRequest("GET", baseURL, nil)
	r.URL.RawQuery = params.Encode()

	return makeTestRequestWithContext(router.getLocalizations, r)
}

func TestGetLocalizations(t *testing.T) {
	Convey("should return a localization for valid game_id and locale", t, func() {
		params := url.Values{
			"game_id": []string{strconv.Itoa(backendtest.TestID)},
			"locale":  []string{backendtest.TestLocale},
		}
		w := performGetLocalizationsRequest(params)

		So(w.Code, ShouldEqual, http.StatusOK)
		So(w.Header().Get("Cache-Control"), ShouldEqual, fmt.Sprintf("public, max-age=%v", defaultMaxCacheAge))

		var l game.Localizations

		dec := json.NewDecoder(w.Body)
		dec.Decode(&l)

		So(l, ShouldResemble, backendtest.TestLocalization(
			backendtest.TestID,
			backendtest.TestLocalizedName,
			backendtest.TestLocale,
		))
	})

	Convey("should return an array of localizations for valid game_id", t, func() {
		params := url.Values{
			"game_id": []string{strconv.Itoa(backendtest.TestID)},
		}
		w := performGetLocalizationsRequest(params)

		So(w.Code, ShouldEqual, http.StatusOK)
		So(w.Header().Get("Cache-Control"), ShouldEqual, fmt.Sprintf("public, max-age=%v", defaultMaxCacheAge))

		var l game.Localizations

		dec := json.NewDecoder(w.Body)
		dec.Decode(&l)

		So(l, ShouldResemble, backendtest.TestLocalization(
			backendtest.TestID,
			backendtest.TestLocalizedName,
			backendtest.TestLocale,
		))
	})

	Convey("should return a localization for good game_name and locale", t, func() {
		params := url.Values{
			"game_name": []string{backendtest.TestTerm},
			"locale":    []string{backendtest.TestLocale},
		}
		w := performGetLocalizationsRequest(params)

		So(w.Code, ShouldEqual, http.StatusOK)
		So(w.Header().Get("Cache-Control"), ShouldEqual, fmt.Sprintf("public, max-age=%v", defaultMaxCacheAge))

		var l game.Localizations

		dec := json.NewDecoder(w.Body)
		dec.Decode(&l)

		So(l, ShouldResemble, backendtest.TestLocalization(
			backendtest.TestID,
			backendtest.TestLocalizedName,
			backendtest.TestLocale,
		))
	})

	Convey("should return an array of localizations for good game_name", t, func() {
		params := url.Values{
			"game_name": []string{backendtest.TestTerm},
		}
		w := performGetLocalizationsRequest(params)

		So(w.Code, ShouldEqual, http.StatusOK)
		So(w.Header().Get("Cache-Control"), ShouldEqual, fmt.Sprintf("public, max-age=%v", defaultMaxCacheAge))

		var l game.Localizations

		dec := json.NewDecoder(w.Body)
		dec.Decode(&l)

		So(l, ShouldResemble, backendtest.TestLocalization(
			backendtest.TestID,
			backendtest.TestLocalizedName,
			backendtest.TestLocale,
		))
	})
}
