package api

import (
	"net/http"
	"net/http/httptest"
	"net/url"
	"testing"

	"code.justin.tv/web/discovery/backend/backendtest"
	. "github.com/smartystreets/goconvey/convey"
)

func performIndexRequest(params url.Values) *httptest.ResponseRecorder {
	be := backendtest.NewBackend()
	router := API{Backend: be}

	r, _ := http.NewRequest("GET", baseURL, nil)
	r.URL.RawQuery = params.Encode()

	return makeTestRequestWithContext(router.index, r)
}

func TestIndex(t *testing.T) {
	Convey("should work", t, func() {
		params := url.Values{}
		w := performIndexRequest(params)

		So(w.Code, ShouldEqual, http.StatusOK)
	})
}
