package api

import (
	"net/http"
	"regexp"
	"strings"

	"github.com/jixwanwang/apiutils"
)

// localeRegex matches locales of the form xx-xx, disregarding character case
var localeRegex = regexp.MustCompile("(?i)^[a-z]{2}(\\-[a-z]{2})?$")

// Returns either empty string or lowercased valid locales
func validateLocale(locale string) (string, *apiutils.ErrorResponse) {
	if locale == "" || localeRegex.MatchString(locale) {
		return strings.ToLower(locale), nil
	}
	return "", &apiutils.ErrorResponse{
		Status:     http.StatusBadRequest,
		Message:    "Malformed locale",
		StatusText: http.StatusText(http.StatusBadRequest),
	}
}
