package api

import (
	"net/http"
	"strings"
	"testing"

	. "github.com/smartystreets/goconvey/convey"
)

const (
	InvalidLocale    = "abc"
	ValidLocaleMixed = "en-uS"
	ValidLocaleLower = "en-us"
	ValidLocaleUpper = "en-US"
)

func TestLocaleHelper(t *testing.T) {
	Convey("should return error response for invalid locale", t, func() {
		invalidLocale, errResponse := validateLocale(InvalidLocale)

		So(errResponse, ShouldNotBeNil)
		So(errResponse.Status, ShouldEqual, http.StatusBadRequest)
		So(errResponse.Message, ShouldEqual, "Malformed locale")
		So(invalidLocale, ShouldEqual, "")
	})

	Convey("should not return error response for valid locales", t, func() {
		validLocale, errResponse := validateLocale(ValidLocaleLower)
		So(errResponse, ShouldBeNil)
		So(validLocale, ShouldEqual, ValidLocaleLower)

		validLocale, errResponse = validateLocale(ValidLocaleUpper)
		So(errResponse, ShouldBeNil)
		So(validLocale, ShouldEqual, strings.ToLower(ValidLocaleUpper))

		validLocale, errResponse = validateLocale(ValidLocaleMixed)
		So(errResponse, ShouldBeNil)
		So(validLocale, ShouldEqual, strings.ToLower(ValidLocaleMixed))

		validLocale, errResponse = validateLocale("")
		So(errResponse, ShouldBeNil)
		So(validLocale, ShouldEqual, "")
	})
}
