package aws

import (
	"log"
	"time"

	"github.com/aws/aws-sdk-go/aws"
	"github.com/aws/aws-sdk-go/aws/credentials"
	"github.com/aws/aws-sdk-go/aws/credentials/ec2rolecreds"
	"github.com/aws/aws-sdk-go/aws/ec2metadata"
	"github.com/aws/aws-sdk-go/aws/session"

	"code.justin.tv/common/config"
)

func init() {
	config.Register(map[string]string{
		"aws-access-key-id":     "",
		"aws-secret-access-key": "",
	})
}

func CreateAwsCredentials() *credentials.Credentials {
	awsAccessKey := config.Resolve("aws-access-key-id")
	awsSecretKey := config.Resolve("aws-secret-access-key")
	if len(awsAccessKey) == 0 || len(awsSecretKey) == 0 {
		log.Printf("Using Credentials from EC2RoleProvider.")
		defaultClient := ec2metadata.New(session.New(aws.NewConfig()))
		return credentials.NewCredentials(&ec2rolecreds.EC2RoleProvider{ExpiryWindow: 5 * time.Minute, Client: defaultClient})
	}
	log.Printf("Using Credentials from Environment.")
	return credentials.NewEnvCredentials()
}
