Discovery API
=============

## Getting game suggestions

Perform a GET request to /game/suggest with a `term` parameter, which will return up to 20 games starting with `term`.

Add the parameter `live=true` to limit results to games currently being broadcasted

**Example**

To get live games starting with "star":

    $ curl "localhost:8080/game/suggest?term=star&live=true"
	[
	  {
	    "name": "StarCraft II: Heart of the Swarm",
	    "id": 21818,
	    "giantbombId": 24078,
	    "images": {
	      "icon": "http://static.giantbomb.com/uploads/square_avatar/9/99864/2456912-954721_114462_front.jpg",
	      "medium": "http://static.giantbomb.com/uploads/scale_medium/9/99864/2456912-954721_114462_front.jpg",
	      "screen": "http://static.giantbomb.com/uploads/screen_medium/9/99864/2456912-954721_114462_front.jpg",
	      "small": "http://static.giantbomb.com/uploads/scale_small/9/99864/2456912-954721_114462_front.jpg",
	      "super": "http://static.giantbomb.com/uploads/scale_large/9/99864/2456912-954721_114462_front.jpg",
	      "thumb": "http://static.giantbomb.com/uploads/scale_avatar/9/99864/2456912-954721_114462_front.jpg",
	      "tiny": "http://static.giantbomb.com/uploads/square_mini/9/99864/2456912-954721_114462_front.jpg"
	    },
	    "popularity": 101,
	    "properties": {},
	    "boxArt": {
	      "large": "http://static-cdn.jtvnw.net/ttv-boxart/StarCraft%20II:%20Heart%20of%20the%20Swarm-272x380.jpg",
	      "medium": "http://static-cdn.jtvnw.net/ttv-boxart/StarCraft%20II:%20Heart%20of%20the%20Swarm-136x190.jpg",
	      "small": "http://static-cdn.jtvnw.net/ttv-boxart/StarCraft%20II:%20Heart%20of%20the%20Swarm-52x72.jpg",
	      "template": "http://static-cdn.jtvnw.net/ttv-boxart/%s-%vx%v.jpg/StarCraft%20II:%20Heart%20of%20the%20Swarm-{width}x{height}.jpg"
	    },
	    "logoArt": {
	      "large": "http://static-cdn.jtvnw.net/ttv-logoart/StarCraft%20II:%20Heart%20of%20the%20Swarm-240x144.jpg",
	      "medium": "http://static-cdn.jtvnw.net/ttv-logoart/StarCraft%20II:%20Heart%20of%20the%20Swarm-120x72.jpg",
	      "small": "http://static-cdn.jtvnw.net/ttv-logoart/StarCraft%20II:%20Heart%20of%20the%20Swarm-60x36.jpg",
	      "template": "http://static-cdn.jtvnw.net/ttv-logoart/%s-%vx%v.jpg/StarCraft%20II:%20Heart%20of%20the%20Swarm-{width}x{height}.jpg"
	    }
	  },
	  .
	  .
	  .
  	]

## Getting game info

Perform a GET request to /game, with one of `name`, `id` parameters.

**Example**

To get info about Starcraft:

    $ curl "localhost:8080/game?name=starcraft"
	{
	  "name": "StarCraft",
	  "id": 11989,
	  "giantbombId": 13062,
	  "images": {
	    "icon": "http://static.giantbomb.com/uploads/square_avatar/0/30/176266-starcraft_box_art.jpg",
	    "medium": "http://static.giantbomb.com/uploads/scale_medium/0/30/176266-starcraft_box_art.jpg",
	    "screen": "http://static.giantbomb.com/uploads/screen_medium/0/30/176266-starcraft_box_art.jpg",
	    "small": "http://static.giantbomb.com/uploads/scale_small/0/30/176266-starcraft_box_art.jpg",
	    "super": "http://static.giantbomb.com/uploads/scale_large/0/30/176266-starcraft_box_art.jpg",
	    "thumb": "http://static.giantbomb.com/uploads/scale_avatar/0/30/176266-starcraft_box_art.jpg",
	    "tiny": "http://static.giantbomb.com/uploads/square_mini/0/30/176266-starcraft_box_art.jpg"
	  },
	  "popularity": 1,
	  "properties": {},
	  "boxArt": {
	    "large": "http://static-cdn.jtvnw.net/ttv-boxart/StarCraft-272x380.jpg",
	    "medium": "http://static-cdn.jtvnw.net/ttv-boxart/StarCraft-136x190.jpg",
	    "small": "http://static-cdn.jtvnw.net/ttv-boxart/StarCraft-52x72.jpg",
	    "template": "http://static-cdn.jtvnw.net/ttv-boxart/StarCraft-{width}x{height}.jpg"
	  },
	  "logoArt": {
	    "large": "http://static-cdn.jtvnw.net/ttv-logoart/StarCraft-240x144.jpg",
	    "medium": "http://static-cdn.jtvnw.net/ttv-logoart/StarCraft-120x72.jpg",
	    "small": "http://static-cdn.jtvnw.net/ttv-logoart/StarCraft-60x36.jpg",
	    "template": "http://static-cdn.jtvnw.net/ttv-logoart/StarCraft-{width}x{height}.jpg"
	  }
	}

## Getting game info for many games

Perform a GET request to /game/list, with an `id` parameter, which is a comma separated list.

You can also use `ordering=name` to sort alphabetically.

**Example**
To get information about Starcraft and StarcraftII:

    $ curl "localhost:8080/game/list?id=21818,11989"
	[
	  {
	    "name": "StarCraft II: Heart of the Swarm",
	    "id": 21818,
	    "giantbombId": 24078,
	    "images": {
	      "icon": "http://static.giantbomb.com/uploads/square_avatar/9/99864/2456912-954721_114462_front.jpg",
	      "medium": "http://static.giantbomb.com/uploads/scale_medium/9/99864/2456912-954721_114462_front.jpg",
	      "screen": "http://static.giantbomb.com/uploads/screen_medium/9/99864/2456912-954721_114462_front.jpg",
	      "small": "http://static.giantbomb.com/uploads/scale_small/9/99864/2456912-954721_114462_front.jpg",
	      "super": "http://static.giantbomb.com/uploads/scale_large/9/99864/2456912-954721_114462_front.jpg",
	      "thumb": "http://static.giantbomb.com/uploads/scale_avatar/9/99864/2456912-954721_114462_front.jpg",
	      "tiny": "http://static.giantbomb.com/uploads/square_mini/9/99864/2456912-954721_114462_front.jpg"
	    },
	    "popularity": 89,
	    "properties": {},
	    "boxArt": {
	      "large": "http://static-cdn.jtvnw.net/ttv-boxart/StarCraft%20II:%20Heart%20of%20the%20Swarm-272x380.jpg",
	      "medium": "http://static-cdn.jtvnw.net/ttv-boxart/StarCraft%20II:%20Heart%20of%20the%20Swarm-136x190.jpg",
	      "small": "http://static-cdn.jtvnw.net/ttv-boxart/StarCraft%20II:%20Heart%20of%20the%20Swarm-52x72.jpg",
	      "template": "http://static-cdn.jtvnw.net/ttv-boxart/StarCraft%20II:%20Heart%20of%20the%20Swarm-{width}x{height}.jpg"
	    },
	    "logoArt": {
	      "large": "http://static-cdn.jtvnw.net/ttv-logoart/StarCraft%20II:%20Heart%20of%20the%20Swarm-240x144.jpg",
	      "medium": "http://static-cdn.jtvnw.net/ttv-logoart/StarCraft%20II:%20Heart%20of%20the%20Swarm-120x72.jpg",
	      "small": "http://static-cdn.jtvnw.net/ttv-logoart/StarCraft%20II:%20Heart%20of%20the%20Swarm-60x36.jpg",
	      "template": "http://static-cdn.jtvnw.net/ttv-logoart/StarCraft%20II:%20Heart%20of%20the%20Swarm-{width}x{height}.jpg"
	    }
	  },
	  {
	    "name": "StarCraft",
	    "id": 11989,
	    "giantbombId": 13062,
	    "images": {
	      "icon": "http://static.giantbomb.com/uploads/square_avatar/0/30/176266-starcraft_box_art.jpg",
	      "medium": "http://static.giantbomb.com/uploads/scale_medium/0/30/176266-starcraft_box_art.jpg",
	      "screen": "http://static.giantbomb.com/uploads/screen_medium/0/30/176266-starcraft_box_art.jpg",
	      "small": "http://static.giantbomb.com/uploads/scale_small/0/30/176266-starcraft_box_art.jpg",
	      "super": "http://static.giantbomb.com/uploads/scale_large/0/30/176266-starcraft_box_art.jpg",
	      "thumb": "http://static.giantbomb.com/uploads/scale_avatar/0/30/176266-starcraft_box_art.jpg",
	      "tiny": "http://static.giantbomb.com/uploads/square_mini/0/30/176266-starcraft_box_art.jpg"
	    },
	    "popularity": 0,
	    "properties": {},
	    "boxArt": {
	      "large": "http://static-cdn.jtvnw.net/ttv-boxart/StarCraft-272x380.jpg",
	      "medium": "http://static-cdn.jtvnw.net/ttv-boxart/StarCraft-136x190.jpg",
	      "small": "http://static-cdn.jtvnw.net/ttv-boxart/StarCraft-52x72.jpg",
	      "template": "http://static-cdn.jtvnw.net/ttv-boxart/StarCraft-{width}x{height}.jpg"
	    },
	    "logoArt": {
	      "large": "http://static-cdn.jtvnw.net/ttv-logoart/StarCraft-240x144.jpg",
	      "medium": "http://static-cdn.jtvnw.net/ttv-logoart/StarCraft-120x72.jpg",
	      "small": "http://static-cdn.jtvnw.net/ttv-logoart/StarCraft-60x36.jpg",
	      "template": "http://static-cdn.jtvnw.net/ttv-logoart/StarCraft-{width}x{height}.jpg"
	    }
	  }
	]



## Add a game

Perform a PUT request to /games, with `giantbomb_id` or `name` parameters.

If `name` is used, an empty game with only the name field set will be added to the DB.

If `giantbomb_id` is used, game information is pulled from giantbomb and input into the DB. 
An existing game with the same giantbomb_id will have its information overwritten.

**Example**

To add Halo CE to the DB using information from Giantbomb:

	$ curl -X PUT -H 'Content-Length':0 "localhost:8080/games?giantbomb_id=2600"


## Add a game alias

Perform a PUT request to /add_alias, with an `alias` parameter and either `id` or `name` parameters.

**Example**

To alias "SC" to Starcraft:

	$ curl -X PUT -H 'Content-Length':0 http://discovery.twitch.tv:9292/add_alias?alias=SC&name=starcraft"


## Get game aliases

Perform a GET request to /aliases, with one of `name`, `id`, `giantbomb_id` parameters.

**Example**

To get aliases for Starcraft:

        $ curl "localhost:8080/aliases?name=starcraft"


## Update game properties

Perform a PATCH request to /game/game/properties, with `name` and `properties` params.

`properties` must be a map of strings to strings, in json format.

**Example**

To give Braid an "a" property and delete the "b" property:

	$ curl -X PATCH -H "Content-Type:application/json" -d '{"name": "braid","properties":{"a":"1","b":null}}'  http://discovery.twitch.tv:9292/game/game/properties"


## Delete a game

Perform a DELETE request to /game, with `giantbomb_id` or `name` parameters.

**Example**

To delete Starcraft from the DB:

	$ curl -X DELETE "localhost:8080/game?name=starcraft"


## Get localizations for a game

Perform a GET request to /localizations, with `game_id` or `game_name` parameters.

**Example**

To get localizations for Overwatch:

	$ curl "localhost:8080/localizations?game_name=overwatch"


## Add a localization for a game

Perform a PUT request to /localizations, with a `locale` and `localized_name` parameter and either `game_id` or `game_name` parameters.

**Example**

To add "オーバーウォッチ" for Overwatch in "ja-jp" locale:

	$ curl -X PUT "localhost:8080/localizations?locale=ja-jp&localized_name=オーバーウォッチ&game_name=overwatch"


## Delete a localization for a game

Perform a DELETE request to /localizations, with a `locale` parameter and either `game_id` or `game_name` parameters.

**Example**

To delete "ja-jp" locale name for Overwatch:

	$ curl -X DELETE "localhost:8080/localizations?game_name=overwatch&locale=ja-jp"


## Delete all localizations for a game

Perform a DELETE request to /localizations/all, with `game_id` or `game_name` parameters.

**Example**

To all localizations for Overwatch:

	$ curl -X DELETE "localhost:8080/localizations/all?game_name=overwatch"

