package game

import (
	"fmt"
	"net/url"
	"testing"

	. "github.com/smartystreets/goconvey/convey"
)

const (
	gameName = "Test game"
)

func TestNewGame(t *testing.T) {
	g := NewGame()

	Convey("should make game with empty maps", t, func() {
		So(g.Images, ShouldNotBeNil)
		So(g.Properties, ShouldNotBeNil)
	})
}

func TestBuildArt(t *testing.T) {
	g := Game{
		Name: gameName,
	}

	g.BuildArt()

	u := &url.URL{Path: gameName}
	urlName := u.String()

	Convey("build art should populate box arts", t, func() {
		for k, v := range boxSizes {
			So(g.BoxArt[k], ShouldContainSubstring, fmt.Sprintf(nameFormat, urlName, v["width"], v["height"]))
			So(g.BoxArt[k], ShouldNotContainSubstring, `%v`)
			So(g.BoxArt[k], ShouldNotContainSubstring, `%s`)
		}
	})

	Convey("build art should populate logo arts", t, func() {
		for k, v := range logoSizes {
			So(g.LogoArt[k], ShouldContainSubstring, fmt.Sprintf(nameFormat, urlName, v["width"], v["height"]))
		}
	})

	Convey("templates in correct format", t, func() {
		So(g.BoxArt["template"], ShouldEqual, fmt.Sprintf(boxArtBase, urlName, template["width"], template["height"]))
		So(g.LogoArt["template"], ShouldEqual, fmt.Sprintf(logoArtBase, urlName, template["width"], template["height"]))
	})
}
